/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.spring;

import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.services.commands.Command;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandTransactionCallback<T>
implements TransactionCallback {
    private final Command<T> command;
    private final EnvironmentFactory environmentFactory;

    public CommandTransactionCallback(Command<T> command, EnvironmentFactory environmentFactory) {
        this.command = command;
        this.environmentFactory = environmentFactory;
    }

    public T doInTransaction(TransactionStatus status) {
        Environment environment = this.environmentFactory.openEnvironment();
        try {
            T t = this.command.execute(environment);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("ooops", e);
        }
        finally {
            environment.close();
        }
    }
}

