/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.xml;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.ReflectUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.xml.Binding;
import org.ow2.orchestra.xml.Bindings;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Element;

public class BindingParser
extends Parser {
    private static final Logger LOG = Logger.getLogger(BindingParser.class.getName());

    public Object parseDocumentElement(Element documentElement, Parse parse) {
        List<Element> elements = XmlUtil.elements(documentElement, "binding");
        if (elements != null) {
            for (Element bindingElement : elements) {
                String bindingClassName = XmlUtil.attribute(bindingElement, "class");
                Misc.fastDynamicLog(LOG, Level.FINEST, "adding wire binding for " + bindingClassName, new Object[0]);
                Binding binding = null;
                if (bindingClassName != null) {
                    try {
                        Class<?> bindingClass = ReflectUtil.loadClass(this.classLoader, bindingClassName);
                        binding = (Binding)bindingClass.newInstance();
                    }
                    catch (Exception e) {
                        parse.addProblem("couldn't instantiate binding " + bindingClassName, e, bindingElement);
                    }
                } else {
                    parse.addProblem("class is a required attribute in a binding " + XmlUtil.toString(bindingElement), bindingElement);
                }
                if (binding != null) {
                    Bindings bindings = parse.findObject(Bindings.class);
                    bindings.addBinding(binding);
                    continue;
                }
                Misc.fastDynamicLog(LOG, Level.WARNING, "WARNING: binding for " + bindingClassName + " could not be parsed. See parsing problems for more details.", new Object[0]);
            }
        }
        return null;
    }
}

