/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.xml;

import java.io.InputStream;
import java.net.URL;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.env.PvmEnvironmentFactory;
import org.ow2.orchestra.env.WireContext;
import org.ow2.orchestra.env.WireDefinition;
import org.ow2.orchestra.env.xml.WireParser;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.util.stream.StreamSource;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class EnvironmentFactoryParser
extends Parser {
    private static final String ENVIRONMENT_ORCHESTRA_XSD = "environment.xsd";
    public static final String CLASSPATH_URL = "classpath://";
    private WireParser environmentFactoryXmlParser = new WireParser();
    private WireParser environmentXmlParser = new WireParser();
    private static final EnvironmentFactoryParser INSTANCE = new EnvironmentFactoryParser();

    public EnvironmentFactoryParser() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public static EnvironmentFactoryParser getInstance() {
        return INSTANCE;
    }

    static EnvironmentFactory parse(StreamSource streamSource) {
        EnvironmentFactory environmentFactory = (EnvironmentFactory)EnvironmentFactoryParser.getInstance().createParse().setStreamSource(streamSource).execute().checkProblems("environment configuration " + streamSource).getDocumentObject();
        return environmentFactory;
    }

    public Object parseDocument(Document document, Parse parse) {
        Element documentElement = document.getDocumentElement();
        PvmEnvironmentFactory pvmEnvironmentFactory = (PvmEnvironmentFactory)parse.getDocumentObject();
        if (pvmEnvironmentFactory == null) {
            pvmEnvironmentFactory = new PvmEnvironmentFactory();
            parse.setDocumentObject(pvmEnvironmentFactory);
        }
        WireDefinition environmentFactoryWireDefinition = this.getApplicationWireDefinition(documentElement, parse);
        WireDefinition environmentWireDefinition = this.getBlockWireDefinition(documentElement, parse);
        WireContext environmentFactoryWireContext = new WireContext(environmentFactoryWireDefinition, "environment-factory");
        environmentFactoryWireContext.setClassLoader(this.classLoader);
        pvmEnvironmentFactory.setEnvironmentFactoryCtxWireContext(environmentFactoryWireContext);
        pvmEnvironmentFactory.setEnvironmentCtxWireDefinition(environmentWireDefinition);
        parse.setDocumentObject(pvmEnvironmentFactory);
        return pvmEnvironmentFactory;
    }

    WireDefinition getApplicationWireDefinition(Element documentElement, Parse parse) {
        Element applicationElement = XmlUtil.element(documentElement, "environment-factory");
        if (applicationElement != null) {
            return (WireDefinition)this.environmentFactoryXmlParser.parseDocumentElement(applicationElement, parse);
        }
        return null;
    }

    WireDefinition getBlockWireDefinition(Element documentElement, Parse parse) {
        Element blockElement = XmlUtil.element(documentElement, "environment");
        if (blockElement != null) {
            return (WireDefinition)this.environmentXmlParser.parseDocumentElement(blockElement, parse);
        }
        return null;
    }

    public WireParser getEnvironmentFactoryXmlParser() {
        return this.environmentFactoryXmlParser;
    }

    public void setEnvironmentFactoryXmlParser(WireParser applicationWireXmlParser) {
        this.environmentFactoryXmlParser = applicationWireXmlParser;
    }

    public WireParser getEnvironmentXmlParser() {
        return this.environmentXmlParser;
    }

    public void setEnvironmentXmlParser(WireParser blockWireXmlParser) {
        this.environmentXmlParser = blockWireXmlParser;
    }

    public static EnvironmentFactory parseEnvironmentFactoryFromXmlString(String xmlString) {
        Parse parse = EnvironmentFactoryParser.getInstance().createParse();
        EnvironmentFactory factory = (EnvironmentFactory)parse.setString(xmlString).execute().getDocumentObject();
        parse.checkProblems("environment");
        return factory;
    }

    public static synchronized EnvironmentFactory parseEnvironmentFactoryFromURL(URL url) {
        if (url == null) {
            throw new OrchestraRuntimeException("No environment xml found");
        }
        Parse parse = EnvironmentFactoryParser.getInstance().createParse();
        PvmEnvironmentFactory factory = (PvmEnvironmentFactory)parse.setUrl(url).execute().getDocumentObject();
        parse.checkProblems("environment");
        return factory;
    }

    public static synchronized EnvironmentFactory parseEnvironmentFactoryFromResource(String resource) {
        Misc.checkArgsNotNull(resource);
        Parse parse = EnvironmentFactoryParser.getInstance().createParse();
        EnvironmentFactory factory = (EnvironmentFactory)parse.setResource(resource).execute().getDocumentObject();
        parse.checkProblems("environment");
        return factory;
    }

    protected String[] getSchemaSources() {
        return new String[]{"classpath://environment.xsd"};
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId.startsWith(CLASSPATH_URL)) {
            String localpart = systemId.substring(CLASSPATH_URL.length());
            InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(localpart);
            if (inStream != null) {
                return new InputSource(inStream);
            }
        }
        return super.resolveEntity(publicId, systemId);
    }
}

