/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.def.full.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.ProcessStateUpdate;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.ScopeActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.ProcessDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.ProcessStateUpdateImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessFullDefinitionImpl
extends ScopeActivityFullDefinitionImpl
implements ProcessFullDefinition {
    private static final long serialVersionUID = 2606705701938051916L;
    protected String nameSpace;
    protected String expressionLanguage;
    protected String queryLanguage;
    protected Date deployedDate;
    protected Date undeployedDate;
    protected ProcessState state;
    protected List<ProcessStateUpdate> stateUpdates;
    protected int version;

    protected ProcessFullDefinitionImpl() {
    }

    public ProcessFullDefinitionImpl(ProcessDefinitionUUID uuid, String nameSpace, String name, String queryLanguage, String expressionLanguage, Date deployedDate) {
        super(uuid, (ActivityDefinitionUUID)uuid, name);
        this.nameSpace = nameSpace;
        this.queryLanguage = queryLanguage;
        this.expressionLanguage = expressionLanguage;
        this.deployedDate = deployedDate;
        this.stateUpdates = new ArrayList<ProcessStateUpdate>();
        this.setState(deployedDate, ProcessState.ACTIVE);
    }

    public ProcessFullDefinitionImpl(ProcessFullDefinition src) {
        super(src);
        this.nameSpace = src.getNameSpace();
        this.expressionLanguage = src.getExpressionLanguage();
        this.queryLanguage = src.getQueryLanguage();
        this.deployedDate = src.getDeployedDate();
        this.undeployedDate = src.getUndeployedDate();
        this.state = src.getState();
        this.stateUpdates = CopyUtil.copyList(src.getStateUpdates());
        this.version = src.getVersion();
    }

    @Override
    public ProcessDefinitionUUID getUUID() {
        return this.processDefinitionUUID;
    }

    @Override
    public String getNameSpace() {
        return this.nameSpace;
    }

    @Override
    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    @Override
    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    @Override
    public Date getDeployedDate() {
        return this.deployedDate;
    }

    @Override
    public Date getUndeployedDate() {
        return this.undeployedDate;
    }

    @Override
    public void setUndeployedDate(Date undeployedDate) {
        this.undeployedDate = undeployedDate;
        this.setState(undeployedDate, ProcessState.UNDEPLOYED);
    }

    @Override
    public ProcessDefinitionImpl copy() {
        return new ProcessDefinitionImpl(this);
    }

    @Override
    public ProcessFullDefinitionImpl fullCopy() {
        return new ProcessFullDefinitionImpl(this);
    }

    @Override
    public ActivityType getType() {
        return ActivityType.PROCESS;
    }

    @Override
    public QName getQName() {
        return new QName(this.getNameSpace(), this.getName());
    }

    @Override
    public ProcessState getState() {
        return this.state;
    }

    @Override
    public List<ProcessStateUpdate> getStateUpdates() {
        return this.stateUpdates;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public void setState(Date date, ProcessState newState) {
        this.state = newState;
        this.stateUpdates.add(new ProcessStateUpdateImpl(date, newState));
    }
}

