/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.jmx;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.ow2.orchestra.cluster.Server;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.data.runtime.JobData;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.exception.ActivityInstanceNotFoundException;
import org.ow2.orchestra.facade.exception.ActivityNotFoundException;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.JobNotFoundException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.ClassLoaderInterceptor;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDeployer
implements RemoteDeployerMBean {
    private final RemoteDeployerMBean impl;

    public RemoteDeployer(Server orchestraServer, EnvironmentFactory environmentFactory) {
        RemoteDeployerImpl remoteDeployer = new RemoteDeployerImpl(orchestraServer, environmentFactory);
        Class<RemoteDeployerMBean> clazz = RemoteDeployerMBean.class;
        ClassLoaderInterceptor clInterceptor = new ClassLoaderInterceptor(remoteDeployer);
        this.impl = (RemoteDeployerMBean)Proxy.newProxyInstance(RemoteDeployer.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)clInterceptor);
    }

    @Override
    public ProcessDefinition deploy(Deployment deployment) {
        return this.impl.deploy(deployment);
    }

    @Override
    public ProcessDefinition deployBar(byte[] barFile) {
        return this.impl.deployBar(barFile);
    }

    @Override
    public void initialize() {
        this.impl.initialize();
    }

    @Override
    public void deployWebServices(ProcessDefinitionUUID processDefinitionUUID) {
        this.impl.deployWebServices(processDefinitionUUID);
    }

    @Override
    public void undeployWebServices(ProcessDefinitionUUID processDefinitionUUID) {
        this.impl.undeployWebServices(processDefinitionUUID);
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions() {
        return this.impl.findProcessDefinitions();
    }

    @Override
    public boolean undeploy(QName processQName) {
        return this.impl.undeploy(processQName);
    }

    @Override
    public boolean undeploy(ProcessDefinitionUUID processDefinitionUUID) {
        return this.impl.undeploy(processDefinitionUUID);
    }

    @Override
    public boolean remove(ProcessDefinitionUUID processDefinitionUUID) {
        return this.impl.remove(processDefinitionUUID);
    }

    @Override
    public boolean activate(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        return this.impl.activate(processDefinitionUUID);
    }

    @Override
    public boolean retire(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        return this.impl.retire(processDefinitionUUID);
    }

    @Override
    public void refreshProcess(ProcessDefinitionUUID processDefinitionUUID) {
        this.impl.refreshProcess(processDefinitionUUID);
    }

    @Override
    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID) throws InstanceNotFoundException {
        return this.impl.findActivityInstances(processUUID);
    }

    @Override
    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID, ActivityState activityState) throws InstanceNotFoundException {
        return this.impl.findActivityInstances(processUUID, activityState);
    }

    @Override
    public Set<ProcessInstance> findProcessInstances() {
        return this.impl.findProcessInstances();
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        return this.impl.findProcessInstances(processDefinitionUUID);
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) throws ProcessNotFoundException {
        return this.impl.findProcessInstances(processDefinitionUUID, processInstanceState);
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ActivityState processInstanceState) {
        return this.impl.findProcessInstances(processInstanceState);
    }

    @Override
    public ActivityInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) throws ActivityInstanceNotFoundException {
        return this.impl.getActivityInstance(activityInstanceUUID);
    }

    @Override
    public ProcessInstance getProcessInstance(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        return this.impl.getProcessInstance(processInstanceUUID);
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(ProcessState state) {
        return this.impl.findProcessDefinitions(state);
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(QName processQName, ProcessState state) {
        return this.impl.findProcessDefinitions(processQName, state);
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(QName processQName) {
        return this.impl.findProcessDefinitions(processQName);
    }

    @Override
    public ActivityDefinition getActivityDefinition(ActivityDefinitionUUID activityDefinitionUUID) throws ActivityNotFoundException {
        return this.impl.getActivityDefinition(activityDefinitionUUID);
    }

    @Override
    public Set<ActivityDefinition> findActivityDefinitions(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        return this.impl.findActivityDefinitions(processUUID);
    }

    @Override
    public ProcessDefinition getProcessDefinition(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        return this.impl.getProcessDefinition(processUUID);
    }

    @Override
    public void exit(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        this.impl.exit(processInstanceUUID);
    }

    @Override
    public void resume(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        this.impl.resume(processInstanceUUID);
    }

    @Override
    public void suspend(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        this.impl.suspend(processInstanceUUID);
    }

    @Override
    public boolean remove(ProcessInstanceUUID processInstanceUUID) {
        return this.impl.remove(processInstanceUUID);
    }

    @Override
    public List<JobData> findJobsWithException() {
        return this.impl.findJobsWithException();
    }

    @Override
    public void retryJob(JobData job, int retries) throws JobNotFoundException {
        this.impl.retryJob(job, retries);
    }
}

