/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.lang.management.ManagementFactory;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.orchestra.cluster.JmxServer;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployer;
import org.ow2.orchestra.jmx.ManagedThreadPool;
import org.ow2.orchestra.services.InvokeExecutor;
import org.ow2.orchestra.services.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.services.jobexecutor.JobExecutor;
import org.ow2.orchestra.services.jobexecutor.pvm.PvmJobExecutor;
import org.ow2.orchestra.util.Misc;

public class JMXAgent {
    private static final Logger LOG = Logger.getLogger(JMXAgent.class.getName());
    private MBeanServer mbs;
    private ObjectName apiObjectName;
    private ObjectName invokeExecutorObjectName;
    private ObjectName jobExecutorObjectName;
    private JMXConnectorServer cs;
    private Registry registry;
    private EnvironmentFactory environmentFactory;

    public void startOrchestra(EnvironmentFactory envFactory) {
        this.environmentFactory = envFactory;
        Properties orchestraProperties = (Properties)envFactory.get("orchestra-properties");
        String jmxServiceUrl = orchestraProperties.getProperty("orchestra.jmx.serviceUrl");
        String jmxObjectName = orchestraProperties.getProperty("orchestra.jmx.objectName");
        JmxServer orchestraServer = new JmxServer(jmxServiceUrl, jmxObjectName);
        RemoteDeployer remoteDeployer = new RemoteDeployer(orchestraServer, envFactory);
        remoteDeployer.initialize();
        JobExecutor jobExecutor = envFactory.get(JobExecutor.class);
        if (jobExecutor != null) {
            if (jobExecutor instanceof AbstractJobExecutor) {
                ((AbstractJobExecutor)jobExecutor).setName(((Object)orchestraServer).toString());
            }
            jobExecutor.start();
        }
        try {
            int jmxPort = Integer.parseInt(orchestraProperties.getProperty("orchestra.jmx.port"));
            this.registry = LocateRegistry.createRegistry(jmxPort);
            this.mbs = ManagementFactory.getPlatformMBeanServer();
            this.apiObjectName = ObjectName.getInstance(jmxObjectName);
            this.mbs.registerMBean(remoteDeployer, this.apiObjectName);
            InvokeExecutor invokeExecutor = envFactory.get(InvokeExecutor.class);
            if (invokeExecutor != null) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("type", "threadPool");
                props.put("name", "InvokeExecutor");
                this.invokeExecutorObjectName = ObjectName.getInstance(this.apiObjectName.getDomain(), props);
                this.mbs.registerMBean(new ManagedThreadPool(invokeExecutor.getExecutorService()), this.invokeExecutorObjectName);
            }
            if (jobExecutor != null && jobExecutor instanceof PvmJobExecutor) {
                PvmJobExecutor pvmJobExecutor = (PvmJobExecutor)jobExecutor;
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("type", "threadPool");
                props.put("name", "JobExecutor");
                this.jobExecutorObjectName = ObjectName.getInstance(this.apiObjectName.getDomain(), props);
                this.mbs.registerMBean(new ManagedThreadPool(pvmJobExecutor.getThreadPool()), this.jobExecutorObjectName);
            }
            JMXServiceURL url = new JMXServiceURL(jmxServiceUrl);
            this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mbs);
            this.cs.start();
            Misc.fastDynamicLog(LOG, Level.INFO, "Orchestra is started using JMX connector [" + this.cs.getAddress().toString() + "]", new Object[0]);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Problem registering mbean in mbean server", e);
        }
    }

    public void stopOrchestra() {
        if (this.mbs != null) {
            try {
                this.cs.stop();
                if (this.apiObjectName != null) {
                    this.mbs.unregisterMBean(this.apiObjectName);
                }
                if (this.invokeExecutorObjectName != null) {
                    this.mbs.unregisterMBean(this.invokeExecutorObjectName);
                }
                if (this.jobExecutorObjectName != null) {
                    this.mbs.unregisterMBean(this.jobExecutorObjectName);
                }
                this.mbs = null;
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("Problem unregistering mbean", e);
            }
        }
        if (this.registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
            catch (NoSuchObjectException e) {
                throw new OrchestraRuntimeException("Problem unregistering rmi registry", e);
            }
            this.registry = null;
        }
        if (this.environmentFactory != null) {
            InvokeExecutor invokeExecutor;
            JobExecutor jobExecutor = this.environmentFactory.get(JobExecutor.class);
            if (jobExecutor != null) {
                jobExecutor.stop(true);
            }
            if ((invokeExecutor = this.environmentFactory.get(InvokeExecutor.class)) != null) {
                invokeExecutor.getExecutorService().shutdown();
            }
            this.environmentFactory.close();
            this.environmentFactory = null;
        }
    }
}

