/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.util.Set;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.facade.QuerierRuntimeAPI;
import org.ow2.orchestra.facade.exception.ActivityInstanceNotFoundException;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.commands.FindActivityInstancesCommand;
import org.ow2.orchestra.jmx.commands.FindProcessInstancesCommand;
import org.ow2.orchestra.jmx.commands.GetActivityInstanceCommand;
import org.ow2.orchestra.jmx.commands.GetProcessInstanceCommand;
import org.ow2.orchestra.services.commands.CommandService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerierRuntimeAPIImpl
implements QuerierRuntimeAPI {
    private final EnvironmentFactory environmentFactory;

    public QuerierRuntimeAPIImpl(EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
    }

    protected CommandService getCommandService() {
        return this.environmentFactory.get(CommandService.class);
    }

    @Override
    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID) throws InstanceNotFoundException {
        try {
            return this.getCommandService().execute(new FindActivityInstancesCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID, ActivityState activityState) throws InstanceNotFoundException {
        try {
            return this.getCommandService().execute(new FindActivityInstancesCommand(processUUID, activityState));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ProcessInstance> findProcessInstances() {
        return this.getCommandService().execute(new FindProcessInstancesCommand());
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new FindProcessInstancesCommand(processDefinitionUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new FindProcessInstancesCommand(processDefinitionUUID, processInstanceState));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ActivityState processInstanceState) {
        return this.getCommandService().execute(new FindProcessInstancesCommand(processInstanceState));
    }

    @Override
    public ProcessInstance getProcessInstance(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        try {
            return this.getCommandService().execute(new GetProcessInstanceCommand(processInstanceUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public ActivityInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) throws ActivityInstanceNotFoundException {
        try {
            return this.getCommandService().execute(new GetActivityInstanceCommand(activityInstanceUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ActivityInstanceNotFoundException) {
                throw (ActivityInstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }
}

