/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActivateProcessCommand
implements Command<Boolean> {
    private static final long serialVersionUID = -1626991011601734973L;
    private final ProcessDefinitionUUID pduuid;

    public ActivateProcessCommand(ProcessDefinitionUUID pduuid) {
        this.pduuid = pduuid;
    }

    @Override
    public Boolean execute(Environment environment) {
        if (this.pduuid == null) {
            throw new IllegalArgumentException("Process definition uuid is null");
        }
        Repository repository = EnvTool.getRepository();
        BpelProcess bpelProcess = repository.getProcess(this.pduuid);
        if (bpelProcess == null) {
            throw new OrchestraWrapperException(new ProcessNotFoundException(this.pduuid));
        }
        BpelProcess activeProcess = repository.getActiveProcess(bpelProcess.getQName());
        if (!bpelProcess.equals(activeProcess)) {
            if (activeProcess != null) {
                repository.retireProcess(activeProcess);
            }
            repository.activateProcess(bpelProcess);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

