/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import org.ow2.orchestra.definition.activity.Exit;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.runtime.BpelInstance;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExitInstanceCommand
implements Command<InstanceNotFoundException> {
    private final ProcessInstanceUUID processInstanceUUID;
    private static final long serialVersionUID = 1L;

    public ExitInstanceCommand(ProcessInstanceUUID processInstanceUUID) {
        this.processInstanceUUID = processInstanceUUID;
    }

    @Override
    public InstanceNotFoundException execute(Environment environment) {
        BpelInstance instance = EnvTool.getRepository().getInstance(this.processInstanceUUID);
        if (instance == null) {
            return new InstanceNotFoundException(this.processInstanceUUID);
        }
        if (instance.getProcessInstanceState().equals((Object)ActivityState.RUNNING) || instance.getProcessInstanceState().equals((Object)ActivityState.SUSPENDED)) {
            new Exit().executeActivity(instance);
        }
        return null;
    }
}

