/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import java.util.HashSet;
import java.util.Set;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindActivityDefinitionsCommand
implements Command<Set<ActivityDefinition>> {
    private static final long serialVersionUID = 3912214314959328185L;
    private final ProcessDefinitionUUID processUUID;

    public FindActivityDefinitionsCommand(ProcessDefinitionUUID processUUID) {
        this.processUUID = processUUID;
    }

    @Override
    public Set<ActivityDefinition> execute(Environment environment) {
        HashSet<ActivityDefinition> result = new HashSet<ActivityDefinition>();
        Querier querier = EnvTool.getQuerier();
        if (querier.getProcessDefinition(this.processUUID) == null) {
            throw new OrchestraWrapperException(new ProcessNotFoundException(this.processUUID));
        }
        Set<ActivityFullDefinition> activityFullDefinitions = querier.findActivityDefinitions(this.processUUID);
        for (ActivityFullDefinition activityFullDefinition : activityFullDefinitions) {
            result.add((ActivityDefinition)activityFullDefinition.copy());
        }
        return result;
    }
}

