/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.data.runtime.JobData;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.job.Job;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindJobsWithExceptionCommand
implements Command<List<JobData>> {
    private static final long serialVersionUID = 8597363585801154662L;

    @Override
    public List<JobData> execute(Environment environment) {
        ArrayList<JobData> result = new ArrayList<JobData>();
        List<Job> jobs = EnvTool.getRepository().findJobsWithException();
        if (jobs != null) {
            for (Job job : jobs) {
                ActivityInstanceUUID activityInstanceUUID = null;
                ProcessInstanceUUID processInstanceUUID = null;
                if (job.getExecution() != null) {
                    BpelExecution jobExecution = job.getExecution();
                    activityInstanceUUID = jobExecution.getActivityInstanceUUID();
                    processInstanceUUID = jobExecution.getProcessInstance().getProcessInstanceUUID();
                }
                JobData jobData = new JobData(job.getClass().getName(), job.getDbid(), job.isSuspended(), job.getDueDate(), job.getException(), job.getRetries(), activityInstanceUUID, processInstanceUUID);
                result.add(jobData);
            }
        }
        return result;
    }
}

