/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.exception.ActivityNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetActivityDefinitionCommand
implements Command<ActivityDefinition> {
    private static final long serialVersionUID = -5103705724343021417L;
    private final ActivityDefinitionUUID activityDefUUID;

    public GetActivityDefinitionCommand(ActivityDefinitionUUID activityDefUUID) {
        this.activityDefUUID = activityDefUUID;
    }

    @Override
    public ActivityDefinition execute(Environment environment) {
        ActivityFullDefinition activityDefinition = EnvTool.getQuerier().getActivityDefinition(this.activityDefUUID);
        if (activityDefinition == null) {
            throw new OrchestraWrapperException(new ActivityNotFoundException(this.activityDefUUID));
        }
        return (ActivityDefinition)activityDefinition.copy();
    }
}

