/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.ActivityInstanceNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetActivityInstanceCommand
implements Command<ActivityInstance> {
    private static final long serialVersionUID = 8856613451037326820L;
    private final ActivityInstanceUUID activityInstanceUUID;

    public GetActivityInstanceCommand(ActivityInstanceUUID activityInstanceUUID) {
        this.activityInstanceUUID = activityInstanceUUID;
    }

    @Override
    public ActivityInstance execute(Environment environment) {
        Querier querier = EnvTool.getQuerier();
        ActivityFullInstance activityInstance = querier.getActivityInstance(this.activityInstanceUUID);
        if (activityInstance == null) {
            throw new OrchestraWrapperException(new ActivityInstanceNotFoundException(this.activityInstanceUUID));
        }
        return (ActivityInstance)activityInstance.copy();
    }
}

