/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.runtime.BpelInstance;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetInstanceCommand
implements Command<ProcessInstanceData> {
    private static final long serialVersionUID = -4282818977685054488L;
    private final ProcessInstanceUUID processUUID;

    public GetInstanceCommand(ProcessInstanceUUID processUUID) {
        this.processUUID = processUUID;
    }

    @Override
    public ProcessInstanceData execute(Environment environment) {
        BpelInstance bpelInstance = EnvTool.getRepository().getInstance(this.processUUID);
        if (bpelInstance != null) {
            return bpelInstance.getProcessInstanceData();
        }
        throw new OrchestraWrapperException(new InstanceNotFoundException(this.processUUID));
    }
}

