/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.data.def.ProcessDefinitionData;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetProcessCommand
implements Command<ProcessDefinitionData> {
    private static final long serialVersionUID = -4282818977685054488L;
    private final ProcessDefinitionUUID processUUID;

    public GetProcessCommand(ProcessDefinitionUUID processUUID) {
        this.processUUID = processUUID;
    }

    @Override
    public ProcessDefinitionData execute(Environment environment) {
        BpelProcess bpelProcess = EnvTool.getRepository().getProcess(this.processUUID);
        if (bpelProcess != null) {
            return bpelProcess.getProcessDefinitionData();
        }
        throw new OrchestraWrapperException(new ProcessNotFoundException(this.processUUID));
    }
}

