/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetProcessDefinitionCommand
implements Command<ProcessDefinition> {
    private static final long serialVersionUID = -5141841183479777975L;
    private final ProcessDefinitionUUID processUUID;

    public GetProcessDefinitionCommand(ProcessDefinitionUUID processUUID) {
        this.processUUID = processUUID;
    }

    @Override
    public ProcessDefinition execute(Environment environment) {
        ProcessFullDefinition process = EnvTool.getQuerier().getProcessDefinition(this.processUUID);
        if (process == null) {
            throw new OrchestraWrapperException(new ProcessNotFoundException(this.processUUID));
        }
        return (ProcessDefinition)process.copy();
    }
}

