/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.itf.Publisher;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InitializeCommand
implements Command<Object> {
    private static final Logger LOG = Logger.getLogger(InitializeCommand.class.getName());
    private static final long serialVersionUID = 1906399701851091793L;

    @Override
    public Object execute(Environment environment) {
        Repository repository = environment.get(Repository.class);
        Publisher publisher = environment.get(Publisher.class);
        Misc.fastDynamicLog(LOG, Level.INFO, "Orchestra initialization.", new Object[0]);
        for (BpelProcess process : repository.getProcesses()) {
            Misc.fastDynamicLog(LOG, Level.INFO, "Redeploying services for process %s", process.getQName());
            publisher.publishServices(process, environment);
        }
        Misc.fastDynamicLog(LOG, Level.INFO, "Orchestra initialized.", new Object[0]);
        return null;
    }
}

