/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.lang.function;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.lang.jaxen.BpelVariableContext;
import org.ow2.orchestra.util.ReflectUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DoXslTransformationFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        Node xpathNodeSet;
        if (args.size() < 2) {
            throw new FunctionCallException("Wrong number of argument for the bpel:doXslTransform function.");
        }
        ContextSupport sup = context.getContextSupport();
        BpelVariableContext variableContext = (BpelVariableContext)sup.getVariableContext();
        Map<String, byte[]> styleSheets = variableContext.getStyleSheets();
        byte[] styleSheetBytes = styleSheets.get(args.get(0));
        if (styleSheetBytes == null) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.xsltStylesheetNotFound);
        }
        try {
            xpathNodeSet = (Node)args.get(1);
        }
        catch (ClassCastException e) {
            try {
                List nodeList = (List)args.get(1);
                xpathNodeSet = (Node)nodeList.get(0);
            }
            catch (Exception e1) {
                throw new FunctionCallException("The second parameter of bpel:doXslTransform must be a valid Node.");
            }
        }
        StreamSource styleSheet = null;
        try {
            styleSheet = new StreamSource(new ByteArrayInputStream(styleSheetBytes));
            TransformerFactory tFactory = XmlUtil.getTransformerFactory();
            Transformer transformer = tFactory.newTransformer(styleSheet);
            for (int i = 2; i < args.size(); i += 2) {
                Collection parList;
                Object param = args.get(i + 1);
                if (param instanceof Collection && (parList = (Collection)param).size() == 1) {
                    param = parList.iterator().next();
                }
                param = this.useDTMManagerOnParam(transformer, param, "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerImpl", "com.sun.org.apache.xalan.internal.xsltc.dom.XSLTCDTMManager", "com.sun.org.apache.xml.internal.dtm.DTMWSFilter");
                param = this.useDTMManagerOnParam(transformer, param, "org.apache.xalan.xsltc.trax.TransformerImpl", "org.apache.xalan.xsltc.dom.XSLTCDTMManager", "org.apache.xml.dtm.DTMWSFilter");
                transformer.setParameter((String)args.get(i), param);
            }
            Document document = XmlUtil.getNewDocument();
            document.appendChild(document.importNode(xpathNodeSet, true));
            DOMSource source = new DOMSource(document);
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            Document doc = (Document)result.getNode();
            ArrayList<Node> listReturned = new ArrayList<Node>();
            listReturned.add(doc.getFirstChild());
            ArrayList<Node> arrayList = listReturned;
            return arrayList;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught when doing xsl transformation : ", e);
        }
        finally {
            try {
                styleSheet.getInputStream().close();
            }
            catch (Exception e) {}
        }
    }

    private Object useDTMManagerOnParam(Transformer transformer, Object param, String transformerClassName, String dtmManagerClassName, String dtmWSFilterClassName) {
        try {
            Class<?> sunTransformerClass = Class.forName(transformerClassName, true, transformer.getClass().getClassLoader());
            if (sunTransformerClass.isInstance(transformer) && param instanceof Node) {
                Class<?> xsltCDTMManagerClass = Class.forName(dtmManagerClassName, true, transformer.getClass().getClassLoader());
                Object instance = xsltCDTMManagerClass.newInstance();
                Class<?> dtmWSFilterClass = Class.forName(dtmWSFilterClassName, true, transformer.getClass().getClassLoader());
                Method m = ReflectUtil.getMethod(xsltCDTMManagerClass, "getDTM", new Class[]{Source.class, Boolean.TYPE, dtmWSFilterClass, Boolean.TYPE, Boolean.TYPE});
                return ReflectUtil.invoke(m, instance, new Object[]{new DOMSource((Node)param), false, null, false, false});
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return param;
    }
}

