/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.lang.jaxen;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.lang.evaluator.PropertyQueryEvaluator;
import org.ow2.orchestra.lang.jaxen.XPathEvaluator;
import org.ow2.orchestra.util.Misc;
import org.w3c.dom.Node;

class XPathPropertyQueryEvaluator
extends XPathEvaluator
implements PropertyQueryEvaluator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(XPathPropertyQueryEvaluator.class.getName());
    private static final FunctionContext FUNCTION_LIBRARY = XPathEvaluator.readFunctionLibrary();

    XPathPropertyQueryEvaluator(String text) throws JaxenException {
        super(text);
    }

    public Node evaluate(Node contextNode) {
        try {
            Context context = this.getContext(contextNode);
            List nodeSet = this.selectNodes(context);
            return this.narrowToSingleNode(nodeSet);
        }
        catch (BpelFaultException e) {
            throw e;
        }
        catch (Exception e) {
            Misc.fastDynamicLog(LOG, Level.SEVERE, "query evaluation failed: %s", e);
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.subLanguageExecutionFault, null, e);
        }
    }

    protected FunctionContext createFunctionContext() {
        return FUNCTION_LIBRARY;
    }

    private Context getContext(Node contextNode) {
        ContextSupport support = this.getContextSupport();
        Context context = new Context(support);
        context.setNodeSet(Collections.singletonList(contextNode));
        return context;
    }
}

