/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.lang.jaxen;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LocationPath;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.lang.evaluator.VariableQueryEvaluator;
import org.ow2.orchestra.lang.jaxen.BpelVariableContext;
import org.ow2.orchestra.lang.jaxen.XPathEvaluator;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.Misc;
import org.w3c.dom.Node;

class XPathVariableQueryEvaluator
extends XPathEvaluator
implements VariableQueryEvaluator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(XPathVariableQueryEvaluator.class.getName());
    private static final FunctionContext FUNCTION_LIBRARY = XPathEvaluator.readBpelFunctionLibrary();

    XPathVariableQueryEvaluator(String text) throws JaxenException {
        super(text);
    }

    public Object evaluate(Node contextNode, BpelExecution bpelExecution) {
        Context context = this.getContext(contextNode, bpelExecution);
        try {
            List nodeSet = this.selectNodes(context);
            return this.narrowToSingleNode(nodeSet);
        }
        catch (BpelFaultException e) {
            throw e;
        }
        catch (Exception e) {
            Misc.fastDynamicLog(LOG, Level.SEVERE, "query evaluation failed: %s", e);
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.subLanguageExecutionFault, null, e);
        }
    }

    public void assign(Node contextNode, BpelExecution bpelExecution, Object value, boolean keepSrcEltName) {
        Expr expr = this.getRootExpr();
        Context context = this.getContext(contextNode, bpelExecution);
        try {
            List nodeSet = expr instanceof LocationPath ? this.selectOrCreateNodes((LocationPath)expr, context) : this.selectNodes(context);
            BpelXmlUtil.setObjectValue(this.narrowToSingleNode(nodeSet), value, keepSrcEltName);
        }
        catch (BpelFaultException e) {
            throw e;
        }
        catch (Exception e) {
            Misc.fastDynamicLog(LOG, Level.SEVERE, "query assignment failed: %s", e);
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.subLanguageExecutionFault, null, e);
        }
    }

    protected FunctionContext createFunctionContext() {
        return FUNCTION_LIBRARY;
    }

    private Context getContext(Node contextNode, BpelExecution bpelExecution) {
        ContextSupport support = this.getContextSupport();
        support.setVariableContext(new BpelVariableContext(bpelExecution));
        Context context = new Context(support);
        context.setNodeSet(Collections.singletonList(contextNode));
        return context;
    }
}

