/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.osgi;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.orchestra.osgi.EnvironmentProviderService;
import org.ow2.orchestra.osgi.ExtensionActivator;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestraWSEngineActivator
extends ExtensionActivator {
    private static final Logger LOG = Logger.getLogger(OrchestraWSEngineActivator.class.getName());
    private static final String DEFAULT_ENV_CONFIG_FILE = "conf/environment.xml";
    private static final String DEFAULT_ENV_CONFIG_RESOURCE = "environment.xml";
    private ServiceRegistration environmentRegistration;

    public OrchestraWSEngineActivator(BundleContext context, Class<?> ... extensions) {
        super(context, extensions);
    }

    @Override
    public synchronized void start() throws Exception {
        super.start();
        URL envUrl = null;
        File envFile = new File(DEFAULT_ENV_CONFIG_FILE);
        if (envFile.exists()) {
            try {
                envUrl = envFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                Misc.unreachableStatement();
            }
        }
        if (envUrl == null) {
            envUrl = this.context.getBundle().getResource(DEFAULT_ENV_CONFIG_RESOURCE);
        }
        Misc.fastDynamicLog(LOG, Level.INFO, "Environment will be taken from: %s", envUrl);
        this.environmentRegistration = this.context.registerService(EnvironmentProviderService.class.getName(), (Object)new EnvironmentProvider(envUrl, this.context), null);
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.environmentRegistration != null) {
            this.environmentRegistration.unregister();
            this.environmentRegistration = null;
        }
        super.stop();
    }

    private static final class EnvironmentProvider
    implements EnvironmentProviderService {
        private final URL envUrl;
        private final Bundle envBundle;

        EnvironmentProvider(URL envUrl, BundleContext bundleContext) {
            this.envUrl = envUrl;
            this.envBundle = bundleContext.getBundle();
        }

        public URL getEnvironmentURL() {
            return this.envUrl;
        }

        public Bundle getEnvironmentBundle() {
            return this.envBundle;
        }
    }
}

