/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.FaultHandlerThatExits;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.full.impl.ProcessFullDefinitionImpl;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.wsdl.WsdlDefinitions;
import org.ow2.orchestra.lang.evaluator.EvaluatorFactory;
import org.ow2.orchestra.parsing.binding.AssignBinding;
import org.ow2.orchestra.parsing.binding.CompensateBinding;
import org.ow2.orchestra.parsing.binding.CompensateScopeBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.parsing.binding.EmptyBinding;
import org.ow2.orchestra.parsing.binding.ExitBinding;
import org.ow2.orchestra.parsing.binding.ExtensionActivityBinding;
import org.ow2.orchestra.parsing.binding.FlowBinding;
import org.ow2.orchestra.parsing.binding.ForEachBinding;
import org.ow2.orchestra.parsing.binding.IfBinding;
import org.ow2.orchestra.parsing.binding.InvokeBinding;
import org.ow2.orchestra.parsing.binding.PickBinding;
import org.ow2.orchestra.parsing.binding.ProcessBinding;
import org.ow2.orchestra.parsing.binding.ReceiveBinding;
import org.ow2.orchestra.parsing.binding.RepeatUntilBinding;
import org.ow2.orchestra.parsing.binding.ReplyBinding;
import org.ow2.orchestra.parsing.binding.RethrowBinding;
import org.ow2.orchestra.parsing.binding.ScopeBinding;
import org.ow2.orchestra.parsing.binding.SequenceBinding;
import org.ow2.orchestra.parsing.binding.ThrowBinding;
import org.ow2.orchestra.parsing.binding.ValidateBinding;
import org.ow2.orchestra.parsing.binding.WaitBinding;
import org.ow2.orchestra.parsing.binding.WhileBinding;
import org.ow2.orchestra.util.ProcessResourcesRepository;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.UrlEntity;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.wsdl.BpelWsdlParser;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.ow2.orchestra.xml.Bindings;
import org.ow2.orchestra.xml.Entity;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelParser
extends Parser {
    private static final String RESSOURCES_DIR = "";
    private static final String[] SCHEMA_RESOURCES = new String[]{"wsdl.xsd", "xml-schema.xsd", "ws-bpel_abstract_common_base.xsd", "ws-bpel_executable.xsd"};
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String CLASSPATH_URL = "classpath://";
    public static final String CATEGORY_ACTIVITY = "activities";
    private static Bindings defaultBindings = BpelParser.getDefaultBindings();
    private static Map<String, Entity> defaultEntities = BpelParser.getDefaultEntities();
    private BpelWsdlParser wsdlParser = new BpelWsdlParser();

    public BpelParser() {
        super(defaultBindings, defaultEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parseDocumentElement(Element processElement, Parse parse) {
        BpelProcess bpelProcess = this.parseProcessAttributes(processElement, parse);
        parse.pushObject(bpelProcess);
        try {
            bpelProcess.setResourcesRepository(parse.findObject(ProcessResourcesRepository.class));
            bpelProcess.setWsdlInfos(parse.findObject(WsdlsInfos.class));
            FaultHandlerThatExits faultHandlerThatExits = new FaultHandlerThatExits();
            faultHandlerThatExits.setExceptionClassName(BpelFaultException.class.getName());
            bpelProcess.setExceptionHandler(faultHandlerThatExits);
            List<Element> elements = XmlUtil.elements(processElement);
            if (elements == null || elements.isEmpty()) {
                parse.addProblem("no elements in process", processElement);
                BpelProcess bpelProcess2 = bpelProcess;
                return bpelProcess2;
            }
            this.parseProcessElements(processElement, bpelProcess, parse);
            Node processScope = (Node)this.parseElement(processElement, parse, CATEGORY_ACTIVITY);
            bpelProcess.setInitial(processScope);
        }
        finally {
            parse.popObject();
        }
        return bpelProcess;
    }

    private BpelProcess parseProcessAttributes(Element processElement, Parse parse) {
        String name = XmlUtil.attribute(processElement, "name");
        String targetNamespace = XmlUtil.attribute(processElement, "targetNamespace");
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        long version = definitionKeeper.getProcessId();
        BpelProcess bpelProcess = new BpelProcess(name, targetNamespace, version);
        String queryLanguage = XmlUtil.attribute(processElement, "queryLanguage");
        if (!EvaluatorFactory.isSupportedLanguage(queryLanguage)) {
            String message = StaticAnalysisFault.getMessage("SA00004", "  Query language '" + queryLanguage + "' not supported.");
            parse.addProblem(message, new StaticAnalysisException("SA00004"), processElement);
            throw new OrchestraRuntimeException(message);
        }
        bpelProcess.setQueryLanguage(queryLanguage);
        String expressionLanguage = XmlUtil.attribute(processElement, "expressionLanguage");
        if (!EvaluatorFactory.isSupportedLanguage(expressionLanguage)) {
            String message = StaticAnalysisFault.getMessage("SA00004", "  Expression language '" + expressionLanguage + "' not supported.");
            parse.addProblem(message, new StaticAnalysisException("SA00004"), processElement);
            throw new OrchestraRuntimeException(message);
        }
        bpelProcess.setExpressionLanguage(expressionLanguage);
        ProcessDefinitionUUID processDefinitionUUID = bpelProcess.getUUID();
        ProcessFullDefinitionImpl processFullDefinition = new ProcessFullDefinitionImpl(processDefinitionUUID, targetNamespace, name, queryLanguage, expressionLanguage, new Date());
        definitionKeeper.setProcessFullDefinition(processFullDefinition);
        return bpelProcess;
    }

    private void parseProcessElements(Element processElement, BpelProcess bpelProcess, Parse parse) {
        List<Element> importElements;
        Element extensions = XmlUtil.element(processElement, "extensions");
        if (extensions != null) {
            parse.addProblem("extensions element not yet supported on process", extensions);
        }
        if ((importElements = XmlUtil.elements(processElement, "import")) != null) {
            for (Element importElement : importElements) {
                this.parseImportElement(importElement, bpelProcess, parse);
            }
        }
    }

    private void parseImportElement(Element importElement, BpelProcess bpelProcess, Parse parse) {
        String namespace = null;
        if (importElement.hasAttribute("namespace")) {
            namespace = importElement.getAttribute("namespace");
        }
        String importType = null;
        if (importElement.hasAttribute("importType")) {
            importType = importElement.getAttribute("importType");
        }
        if (importType == null) {
            parse.addProblem("missing importType attribute in import element " + XmlUtil.toString(importElement), importElement);
        } else if (importType.equals("http://schemas.xmlsoap.org/wsdl/")) {
            WsdlDefinitions wsdlDefinitions = parse.findObject(WsdlDefinitions.class);
            Set<Definition> definitionsForNS = null;
            if (wsdlDefinitions != null) {
                definitionsForNS = wsdlDefinitions.getWsdlDefinitions(namespace);
            }
            if (definitionsForNS == null) {
                parse.addProblem("No wsdl file to import in import element " + XmlUtil.toString(importElement), importElement);
            } else {
                for (Definition wsdlDef : definitionsForNS) {
                    if (namespace == null && wsdlDef.getTargetNamespace() != null) {
                        parse.addProblem("invalid namespace in imported wsdl (SA00012) : no target namespace expected, got \"" + wsdlDef.getTargetNamespace() + "\"", importElement);
                    } else if (namespace != null && !namespace.equals(wsdlDef.getTargetNamespace())) {
                        parse.addProblem("invalid namespace in imported wsdl (SA00011) : expected \"" + namespace + "\", got \"" + wsdlDef.getTargetNamespace() + "\"", importElement);
                    }
                    Map portTypes = wsdlDef.getAllPortTypes();
                    for (PortType pt : portTypes.values()) {
                        List operations = pt.getOperations();
                        for (int index = 0; index < operations.size(); ++index) {
                            Operation op = (Operation)operations.get(index);
                            OperationType opType = op.getStyle();
                            if (opType != null && (opType.equals(OperationType.NOTIFICATION) || opType.equals(OperationType.SOLICIT_RESPONSE))) {
                                String message = StaticAnalysisFault.getMessage("SA00001", "  PortType " + pt.getQName().toString() + " has unsupported operation type: " + opType.toString());
                                parse.addProblem(message, new StaticAnalysisException("SA00001"), importElement);
                            }
                            String name = op.getName();
                            int cmpt = 1;
                            for (int i = index + 1; i < operations.size(); ++i) {
                                if (!((Operation)operations.get(i)).getName().equals(name)) continue;
                                ++cmpt;
                            }
                            if (cmpt <= true) continue;
                            String message = StaticAnalysisFault.getMessage("SA00002", "  PartnerLink " + pt.getQName().toString() + " has " + cmpt + " operations with name " + name);
                            parse.addProblem(message, new StaticAnalysisException("SA00002"), importElement);
                        }
                    }
                    this.wsdlParser.parse(wsdlDef, parse, bpelProcess.getQueryLanguage(), bpelProcess, bpelProcess.getWsdlInfos());
                }
            }
        } else {
            parse.addProblem("unsupported importType attribute in import element " + XmlUtil.toString(importElement), importElement.getAttributeNode("importType"));
        }
    }

    public static Bindings getDefaultBindings() {
        Bindings bindings = new Bindings();
        bindings.addBinding(new ProcessBinding());
        bindings.addBinding(new SequenceBinding());
        bindings.addBinding(new ScopeBinding());
        bindings.addBinding(new ReceiveBinding());
        bindings.addBinding(new ReplyBinding());
        bindings.addBinding(new FlowBinding());
        bindings.addBinding(new EmptyBinding());
        bindings.addBinding(new AssignBinding());
        bindings.addBinding(new InvokeBinding());
        bindings.addBinding(new IfBinding());
        bindings.addBinding(new CompensateBinding());
        bindings.addBinding(new CompensateScopeBinding());
        bindings.addBinding(new ExitBinding());
        bindings.addBinding(new ForEachBinding());
        bindings.addBinding(new PickBinding());
        bindings.addBinding(new RepeatUntilBinding());
        bindings.addBinding(new ThrowBinding());
        bindings.addBinding(new RethrowBinding());
        bindings.addBinding(new ValidateBinding());
        bindings.addBinding(new WaitBinding());
        bindings.addBinding(new WhileBinding());
        bindings.addBinding(new ExtensionActivityBinding());
        return bindings;
    }

    protected static QName getBPELQName(String localName) {
        return new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", localName);
    }

    public static Set<QName> getAllActivityQNames() {
        Set<String> allActivityTagNames = BpelParser.getDefaultBindings().getTagNames(CATEGORY_ACTIVITY);
        HashSet<QName> allActivityQNames = new HashSet<QName>();
        for (String tagName : allActivityTagNames) {
            allActivityQNames.add(BpelParser.getBPELQName(tagName));
        }
        return allActivityQNames;
    }

    private static Map<String, Entity> getDefaultEntities() {
        HashMap<String, Entity> defaultSchemaCatalog = new HashMap<String, Entity>();
        ClassLoader resourceLoader = BpelParser.class.getClassLoader();
        defaultSchemaCatalog.put("http://schemas.xmlsoap.org/wsdl/", new UrlEntity("wsdl.xsd", resourceLoader));
        defaultSchemaCatalog.put(W3C_XML_SCHEMA, new UrlEntity("xml-schema.xsd", resourceLoader));
        defaultSchemaCatalog.put("http://www.w3.org/2001/xml.xsd", new UrlEntity("xml-schema.xsd", resourceLoader));
        defaultSchemaCatalog.put("http://docs.oasis-open.org/wsbpel/2.0/process/abstract", new UrlEntity("ws-bpel_abstract_common_base.xsd", resourceLoader));
        defaultSchemaCatalog.put("http://docs.oasis-open.org/wsbpel/2.0/process/executable", new UrlEntity("ws-bpel_executable.xsd", resourceLoader));
        return defaultSchemaCatalog;
    }

    @Override
    protected String[] getSchemaSources() {
        String[] schemas = new String[SCHEMA_RESOURCES.length];
        for (int i = 0; i < SCHEMA_RESOURCES.length; ++i) {
            schemas[i] = CLASSPATH_URL + SCHEMA_RESOURCES[i];
        }
        return schemas;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId.startsWith(CLASSPATH_URL)) {
            String localpart = systemId.substring(CLASSPATH_URL.length());
            InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(localpart);
            if (inStream != null) {
                return new InputSource(inStream);
            }
        }
        return super.resolveEntity(publicId, systemId);
    }
}

