/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.activity.Flow;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.Link;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.definition.element.Source;
import org.ow2.orchestra.definition.element.Target;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.full.BaseFCTFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityWithChildrenFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityWithSingleChildFullDefinition;
import org.ow2.orchestra.facade.def.full.ElseFullDefinition;
import org.ow2.orchestra.facade.def.full.ElseIfFullDefinition;
import org.ow2.orchestra.facade.def.full.OnAlarmFullDefinition;
import org.ow2.orchestra.facade.def.full.OnEventFullDefinition;
import org.ow2.orchestra.facade.def.full.OnMessageFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.SourceFullImpl;
import org.ow2.orchestra.facade.def.full.impl.TargetFullImpl;
import org.ow2.orchestra.facade.def.full.impl.UnknownActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.lang.JoinCondition;
import org.ow2.orchestra.lang.evaluator.EvaluatorFactory;
import org.ow2.orchestra.parsing.BpelParser;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.ow2.orchestra.xml.TagBinding;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityBinding
extends TagBinding {
    private final ActivityType activityType;

    protected ActivityBinding(String tagName, ActivityType activityType) {
        super(tagName, "http://docs.oasis-open.org/wsbpel/2.0/process/executable", "activities");
        this.activityType = activityType;
    }

    public void setEnclosingScope(AbstractBpelActivity activity, Parse parse) {
        Scope enclosingScope = parse.findObject(Scope.class);
        if (enclosingScope != null) {
            activity.setEnclosingScope(enclosingScope);
        }
    }

    protected void parseStandardAttributes(Element activityElement, AbstractBpelActivity activity, Parse parse) {
        String name = XmlUtil.attribute(activityElement, "name");
        if (name == null) {
            name = "unnamed";
        }
        activity.setName(name);
        String suppressJoinFailureSt = XmlUtil.attribute(activityElement, "suppressJoinFailure");
        AbstractBpelActivity enclosingActivity = parse.findObject(AbstractBpelActivity.class);
        boolean defaultSuppressJoinFailure = false;
        if (enclosingActivity != null) {
            defaultSuppressJoinFailure = enclosingActivity.isSuppressJoinFailure();
        }
        boolean suppressJoinFailure = BpelUtil.booleanValue(suppressJoinFailureSt, defaultSuppressJoinFailure);
        activity.setSuppressJoinFailure(suppressJoinFailure);
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
        ActivityDefinitionUUID activityDefinitionUUID = null;
        activityDefinitionUUID = activity.getType().equals((Object)ActivityType.PROCESS) ? processDefinitionUUID : new ActivityDefinitionUUID((ProcessDefinitionUUID)processDefinitionUUID, definitionKeeper.getNextActivityCount(), this.activityType, name);
        activity.setUUID(activityDefinitionUUID);
        BpelActivityFullDefinition activityFullDefinition = this.createActivityFullDefinition((ProcessDefinitionUUID)processDefinitionUUID, activityDefinitionUUID, name, parse);
        activityFullDefinition.setSuppressJoinFailure(suppressJoinFailure);
        Object parentObject = definitionKeeper.getParent();
        if (parentObject != null) {
            if (parentObject instanceof BpelActivityWithChildrenFullDefinition) {
                BpelActivityWithChildrenFullDefinition activityWithChildrenFullDefinition = (BpelActivityWithChildrenFullDefinition)parentObject;
                activityWithChildrenFullDefinition.addEnclosedActivity(activityFullDefinition);
            } else if (parentObject instanceof BpelActivityWithSingleChildFullDefinition) {
                BpelActivityWithSingleChildFullDefinition activityWithSingleChildFullDefinition = (BpelActivityWithSingleChildFullDefinition)parentObject;
                activityWithSingleChildFullDefinition.setEnclosedActivity(activityFullDefinition);
            } else if (parentObject instanceof ElseIfFullDefinition) {
                ((ElseIfFullDefinition)parentObject).setEnclosedActivityFullDefinition(activityFullDefinition);
                ((ElseIfFullDefinition)parentObject).setActivityDefinitionUUID(activityFullDefinition.getUUID());
            } else if (parentObject instanceof ElseFullDefinition) {
                ((ElseFullDefinition)parentObject).setEnclosedActivityFullDefinition(activityFullDefinition);
                ((ElseFullDefinition)parentObject).setActivityDefinitionUUID(activityFullDefinition.getUUID());
            } else if (parentObject instanceof OnMessageFullDefinition) {
                ((OnMessageFullDefinition)parentObject).setEnclosedActivityFullDefinition(activityFullDefinition);
                ((OnMessageFullDefinition)parentObject).setActivityDefinitionUUID(activityFullDefinition.getUUID());
            } else if (parentObject instanceof OnEventFullDefinition) {
                ((OnEventFullDefinition)parentObject).setEnclosedActivityFullDefinition(activityFullDefinition);
                ((OnEventFullDefinition)parentObject).setActivityDefinitionUUID(activityFullDefinition.getUUID());
            } else if (parentObject instanceof OnAlarmFullDefinition) {
                ((OnAlarmFullDefinition)parentObject).setEnclosedActivityFullDefinition(activityFullDefinition);
                ((OnAlarmFullDefinition)parentObject).setActivityDefinitionUUID(activityFullDefinition.getUUID());
            } else if (parentObject instanceof BaseFCTFullDefinition) {
                ((BaseFCTFullDefinition)parentObject).setEnclosedActivity(activityFullDefinition);
            } else {
                Misc.unreachableStatement("parent has bad type " + parentObject.getClass() + " in activity " + (Object)((Object)activity.getType()));
            }
        }
        definitionKeeper.setActivityFullDefinition(activityFullDefinition);
    }

    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new UnknownActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }

    protected void parseStandardElements(Element activityElement, AbstractBpelActivity activity, Parse parse) {
        Element targetsElement;
        Element sourcesElement = XmlUtil.element(activityElement, "sources");
        if (sourcesElement != null) {
            List<Element> sourceElements = XmlUtil.elements(sourcesElement, "source");
            this.parseSources(sourceElements, parse, activity);
        }
        if ((targetsElement = XmlUtil.element(activityElement, "targets")) != null) {
            List<Element> targetElements = XmlUtil.elements(targetsElement, "target");
            this.parseTargets(targetElements, parse, activity);
            DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
            BpelActivityFullDefinition activityFullDefinition = (BpelActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
            Element targetsJoinConditionElement = XmlUtil.element(targetsElement, "joinCondition");
            String expressionLanguage = null;
            String booleanExpression = null;
            if (targetsJoinConditionElement != null) {
                expressionLanguage = XmlUtil.attribute(targetsJoinConditionElement, "expressionLanguage");
                BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
                if (expressionLanguage == null) {
                    expressionLanguage = bpelProcess.getExpressionLanguage();
                }
                JoinCondition joinCondition = new JoinCondition();
                booleanExpression = targetsJoinConditionElement.getTextContent();
                joinCondition.setText(booleanExpression);
                if (!EvaluatorFactory.isSupportedLanguage(expressionLanguage)) {
                    String message = StaticAnalysisFault.getMessage("SA00004", "  Expression language '" + expressionLanguage + "' not supported.");
                    parse.addProblem(message, new StaticAnalysisException("SA00004"), targetsJoinConditionElement);
                }
                joinCondition.setLanguage(expressionLanguage);
                joinCondition.setNamespaces(BpelUtil.getAllNameSpaces(targetsJoinConditionElement));
                activity.setTargetsJoinCondition(joinCondition);
            }
            activityFullDefinition.setTargetsJoinConditionExpressionLanguage(expressionLanguage);
            activityFullDefinition.setTargetsJoinConditionBooleanExpression(booleanExpression);
        }
    }

    private void parseSources(List<Element> sourceElements, Parse parse, AbstractBpelActivity activity) {
        ArrayList<Source> sources = new ArrayList<Source>();
        if (sourceElements != null) {
            DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
            BpelActivityFullDefinition activityFullDefinition = (BpelActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
            BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
            for (Element sourceElement : sourceElements) {
                String message;
                Flow flow;
                String linkName = XmlUtil.attribute(sourceElement, "linkName");
                boolean exist = false;
                for (Source source : sources) {
                    if (!source.getLinkName().equals(linkName)) continue;
                    String message2 = StaticAnalysisFault.getMessage("SA00068", "  Activity " + activity.getName() + " defines 2 sources with same link " + linkName);
                    parse.addProblem(message2, new StaticAnalysisException("SA00068"), sourceElement);
                    exist = true;
                    break;
                }
                if (exist) continue;
                Source source = new Source();
                source.setLinkName(linkName);
                Element transitionConditionElement = XmlUtil.element(sourceElement, "transitionCondition");
                String expressionLanguage = null;
                String booleanExpression = null;
                if (transitionConditionElement != null) {
                    expressionLanguage = XmlUtil.attribute(transitionConditionElement, "expressionLanguage");
                    if (expressionLanguage == null) {
                        expressionLanguage = bpelProcess.getExpressionLanguage();
                    }
                    Expression expression = new Expression();
                    if (!EvaluatorFactory.isSupportedLanguage(expressionLanguage)) {
                        String message3 = StaticAnalysisFault.getMessage("SA00004", "  Expression language '" + expressionLanguage + "' not supported.");
                        parse.addProblem(message3, new StaticAnalysisException("SA00004"), transitionConditionElement);
                    }
                    expression.setLanguage(expressionLanguage);
                    expression.setNamespaces(BpelUtil.getAllNameSpaces(transitionConditionElement));
                    booleanExpression = transitionConditionElement.getTextContent();
                    expression.setText(booleanExpression);
                    source.setTransitionCondition(expression);
                }
                sources.add(source);
                List<Flow> flows = parse.findObjects(Flow.class);
                Link link = null;
                Iterator<Flow> i$ = flows.iterator();
                while (i$.hasNext() && (link = (flow = i$.next()).getLink(linkName)) == null) {
                }
                if (link == null) {
                    message = StaticAnalysisFault.getMessage("SA00065", "  Activity " + activity.getName() + " defines source with link " + linkName + " that is not defined in enclosing flow");
                    parse.addProblem(message, new StaticAnalysisException("SA00065"), sourceElement);
                } else if (link.getSourceActivity() == null) {
                    link.setSourceActivity(activity);
                    source.setLink(link);
                } else {
                    message = StaticAnalysisFault.getMessage("SA00066", "  Link " + linkName + " has 2 sources defined");
                    parse.addProblem(message, new StaticAnalysisException("SA00066"), sourceElement);
                }
                activityFullDefinition.addSource(new SourceFullImpl(linkName, expressionLanguage, booleanExpression));
            }
        }
        activity.setSources(sources);
    }

    private void parseTargets(List<Element> targetElements, Parse parse, AbstractBpelActivity activity) {
        ArrayList<Target> targets = new ArrayList<Target>();
        if (targetElements != null) {
            DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
            BpelActivityFullDefinition activityFullDefinition = (BpelActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
            for (Element targetElement : targetElements) {
                String message;
                Flow flow;
                String linkName = XmlUtil.attribute(targetElement, "linkName");
                boolean exist = false;
                for (Target target : targets) {
                    if (!target.getLinkName().equals(linkName)) continue;
                    String message2 = StaticAnalysisFault.getMessage("SA00069", "  Activity " + activity.getName() + " defines 2 targets with same link " + linkName);
                    parse.addProblem(message2, new StaticAnalysisException("SA00069"), targetElement);
                    exist = true;
                    break;
                }
                if (exist) continue;
                Target target = new Target();
                target.setLinkName(linkName);
                targets.add(target);
                List<Flow> flows = parse.findObjects(Flow.class);
                Link link = null;
                Iterator<Flow> i$ = flows.iterator();
                while (i$.hasNext() && (link = (flow = i$.next()).getLink(linkName)) == null) {
                }
                if (link == null) {
                    message = StaticAnalysisFault.getMessage("SA00065", "  Activity " + activity.getName() + " defines target with link " + linkName + " that is not defined in enclosing flow");
                    parse.addProblem(message, new StaticAnalysisException("SA00065"), targetElement);
                } else if (link.getTargetActivity() == null) {
                    link.setTargetActivity(activity);
                    target.setLink(link);
                } else {
                    message = StaticAnalysisFault.getMessage("SA00066", "  Link " + linkName + " has 2 targets defined");
                    parse.addProblem(message, new StaticAnalysisException("SA00066"), targetElement);
                }
                activityFullDefinition.addTarget(new TargetFullImpl(linkName));
            }
        }
        activity.setTargets(targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseChildrenActivities(Element activityElement, Parse parse, Parser parser) {
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        try {
            definitionKeeper.pushParent();
            Set<QName> allActivityTagNames = BpelParser.getAllActivityQNames();
            List<Element> activityElements = XmlUtil.elementsQName(activityElement, allActivityTagNames);
            if (activityElements.size() == 0) {
                parse.addProblem("No activity was specified under this element. Please specify one of " + allActivityTagNames, activityElement);
                return;
            }
            for (Element childrenElement : activityElements) {
                parser.parseElement(childrenElement, parse, "activities");
            }
        }
        finally {
            definitionKeeper.popParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node parseChildActivity(Element parentElement, Parse parse, Parser parser) {
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        try {
            Set<QName> allActivityTagNames;
            List<Element> activityElements;
            if (!(definitionKeeper.getParent() instanceof ElseIfFullDefinition || definitionKeeper.getParent() instanceof ElseFullDefinition || definitionKeeper.getParent() instanceof OnMessageFullDefinition || definitionKeeper.getParent() instanceof OnEventFullDefinition || definitionKeeper.getParent() instanceof OnAlarmFullDefinition)) {
                definitionKeeper.pushParent();
            }
            if ((activityElements = XmlUtil.elementsQName(parentElement, allActivityTagNames = BpelParser.getAllActivityQNames())).size() == 0) {
                parse.addProblem("No activity was specified under this element. Please specify one of " + allActivityTagNames, parentElement);
                Node node = null;
                return node;
            }
            Element childrenElement = activityElements.get(0);
            Node node = (Node)parser.parseElement(childrenElement, parse, "activities");
            return node;
        }
        finally {
            if (!(definitionKeeper.getParent() instanceof ElseIfFullDefinition || definitionKeeper.getParent() instanceof ElseFullDefinition || definitionKeeper.getParent() instanceof OnMessageFullDefinition || definitionKeeper.getParent() instanceof OnEventFullDefinition || definitionKeeper.getParent() instanceof OnAlarmFullDefinition)) {
                definitionKeeper.popParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createActivityNodeWithChildren(Element activityElement, Parse parse, Parser parser, AbstractActivity activityBehaviour) {
        Node activityNode = this.createActivityNode(parse, parser, activityBehaviour);
        parse.pushObject(activityNode);
        parse.pushObject(activityBehaviour);
        try {
            this.parseChildrenActivities(activityElement, parse, parser);
        }
        finally {
            parse.popObject();
            parse.popObject();
        }
        return activityNode;
    }

    protected String getNodeName(Element activityElement) {
        return XmlUtil.getTagLocalName(activityElement) + " " + XmlUtil.attribute(activityElement, "name");
    }

    protected String getNodeName(String activityNodeName, String activityName) {
        return activityNodeName + " " + activityName;
    }

    protected Node createActivityNode(Parse parse, Parser parser, AbstractActivity activityBehaviour) {
        Node parentNode = parse.findObject(Node.class);
        Node activityNode = null;
        if (parentNode != null) {
            activityNode = parentNode.createNode(activityBehaviour.getUUID());
        } else {
            BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
            activityNode = bpelProcess.createNode(activityBehaviour.getUUID());
        }
        activityNode.setBehaviour(activityBehaviour);
        return activityNode;
    }

    protected PartnerLink findPartnerLinkDefinition(Parse parse, String partnerLinkName) {
        Scope enclosingScope = parse.findObject(Scope.class);
        return enclosingScope.findPartnerLink(partnerLinkName);
    }
}

