/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.Assign;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.From;
import org.ow2.orchestra.definition.element.FromTo;
import org.ow2.orchestra.definition.element.Literal;
import org.ow2.orchestra.definition.element.To;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.CopyDefinition;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.AssignActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.CopyFullDefinition;
import org.ow2.orchestra.facade.def.full.FromToFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.AssignActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.CopyFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.FromFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.ToFullDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.LiteralDefinitionImpl;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.lang.VariableQuery;
import org.ow2.orchestra.lang.evaluator.EvaluatorFactory;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(AssignBinding.class.getName());

    public AssignBinding() {
        super("assign", ActivityType.ASSIGN);
    }

    @Override
    public Object parse(Element element, Parse parse, Parser parser) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        Assign assign = new Assign();
        this.setEnclosingScope(assign, parse);
        this.parseStandardAttributes(element, assign, parse);
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        this.parseStandardElements(element, assign, parse);
        boolean validate = BpelUtil.booleanValue(XmlUtil.attribute(element, "validate"), false);
        if (validate) {
            parse.addProblem("validate attribute not yet supported on assign activity", element);
            assign.setValidate(validate);
        }
        ((AssignActivityFullDefinition)activityFullDefinition).setValidate(assign.isValidate());
        List<Element> copyElements = XmlUtil.elements(element, "copy");
        this.parseCopies(copyElements, assign, parse);
        List<Element> extensionAssignOperationElements = XmlUtil.elements(element, "extensionAssignOperation");
        if (extensionAssignOperationElements != null) {
            parse.addProblem("extensionAssignOperation not yet supported on assign activity", element);
        }
        Node activityNode = this.createActivityNode(parse, parser, assign);
        return activityNode;
    }

    private void parseCopies(List<Element> copyElements, Assign assign, Parse parse) {
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        List<CopyDefinition> copyDefinitionList = ((AssignActivityFullDefinition)activityFullDefinition).getCopyDefinitions();
        ArrayList<Copy> copies = new ArrayList<Copy>();
        if (copyElements != null) {
            for (Element copyElement : copyElements) {
                copies.add(this.parseCopy(copyElement, parse, assign.getEnclosingScope(), copyDefinitionList));
            }
        }
        assign.setCopies(copies);
        ((AssignActivityFullDefinition)activityFullDefinition).setCopyDefinitions(copyDefinitionList);
    }

    private Copy parseCopy(Element copyElement, Parse parse, Scope enclosingScope, List<CopyDefinition> copyDefinitionList) {
        CopyFullDefinitionImpl copyFullDefinition = new CopyFullDefinitionImpl();
        Copy copy = new Copy();
        boolean keepSrcElementName = BpelUtil.booleanValue(XmlUtil.attribute(copyElement, "keepSrcElementName"), false);
        copy.setKeepSrcElementName(keepSrcElementName);
        boolean ignoreMissingFromData = BpelUtil.booleanValue(XmlUtil.attribute(copyElement, "ignoreMissingFromData"), false);
        copy.setIgnoreMissingFromData(ignoreMissingFromData);
        AssignBinding.parseFrom(XmlUtil.element(copyElement, "from"), copy, parse, enclosingScope, copyFullDefinition);
        this.parseTo(XmlUtil.element(copyElement, "to"), copy, parse, enclosingScope, copyFullDefinition);
        copyDefinitionList.add(copyFullDefinition);
        return copy;
    }

    protected static void parseFrom(Element fromElement, Copy copy, Parse parse, Scope enclosingScope, CopyFullDefinition copyFullDefinition) {
        FromFullDefinitionImpl fromFullDefinition = new FromFullDefinitionImpl();
        From from = new From();
        from.setEndpointReference(XmlUtil.attribute(fromElement, "endpointReference"));
        AssignBinding.parseFromTo(fromElement, from, parse, enclosingScope, fromFullDefinition);
        Element literalElement = XmlUtil.element(fromElement, "literal");
        if (literalElement != null) {
            from.setLiteral(AssignBinding.parseLiteral(literalElement));
            from.setVariant(Variant.LITERAL);
            fromFullDefinition.setVariant(Variant.LITERAL);
        }
        copy.setFrom(from);
        LiteralDefinitionImpl literalDefinition = new LiteralDefinitionImpl(literalElement);
        fromFullDefinition.setLiteral(literalDefinition);
        fromFullDefinition.setEndpointReference(from.getEndpointReference());
        copyFullDefinition.addFromDefinition(fromFullDefinition);
    }

    private void parseTo(Element toElement, Copy copy, Parse parse, Scope enclosingScope, CopyFullDefinition copyFullDefinition) {
        ToFullDefinitionImpl toFullDefinition = new ToFullDefinitionImpl();
        To to = new To();
        AssignBinding.parseFromTo(toElement, to, parse, enclosingScope, toFullDefinition);
        copy.setTo(to);
        copyFullDefinition.addToDefinition(toFullDefinition);
    }

    protected static void parseFromTo(Element fromToElement, FromTo fromTo, Parse parse, Scope enclosingScope, FromToFullDefinition fromToFullDefinition) {
        fromTo.setVariable(XmlUtil.attribute(fromToElement, "variable"));
        fromTo.setPart(XmlUtil.attribute(fromToElement, "part"));
        fromTo.setProperty(XmlUtil.attributeQName(fromToElement, "property"));
        fromTo.setPartnerLink(XmlUtil.attribute(fromToElement, "partnerLink"));
        fromToFullDefinition.setPart(fromTo.getPart());
        fromToFullDefinition.setVariable(fromTo.getVariable());
        fromToFullDefinition.setProperty(fromTo.getProperty());
        fromToFullDefinition.setPartnerLink(fromTo.getPartnerLink());
        BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
        if (fromTo.getVariable() != null && fromTo.getProperty() == null) {
            fromTo.setVariant(Variant.VAR);
            Element queryElement = XmlUtil.element(fromToElement, "query");
            if (queryElement != null) {
                String queryLanguage = XmlUtil.attribute(queryElement, "queryLanguage");
                if (queryLanguage == null) {
                    queryLanguage = bpelProcess.getQueryLanguage();
                }
                VariableQuery query = new VariableQuery();
                if (!EvaluatorFactory.isSupportedLanguage(queryLanguage)) {
                    String message = StaticAnalysisFault.getMessage("SA00004", "  Query language '" + queryLanguage + "' not supported.");
                    parse.addProblem(message, new StaticAnalysisException("SA00004"), fromToElement);
                }
                query.setLanguage(queryLanguage);
                query.setNamespaces(BpelUtil.getAllNameSpaces(queryElement));
                query.setText(queryElement.getTextContent());
                fromTo.setVariableQuery(query);
                fromToFullDefinition.setQuery(fromTo.getVariableQuery().getText());
                fromToFullDefinition.setQueryLanguage(fromTo.getVariableQuery().getLanguage());
            }
            fromToFullDefinition.setVariant(Variant.VAR);
        } else if (fromTo.getVariable() != null) {
            fromTo.setVariant(Variant.PROP);
            String queryString = "bpel_func:getVariableProperty(\"" + fromTo.getVariable() + "\",\"" + fromTo.getProperty().getPrefix() + ":" + fromTo.getProperty().getLocalPart() + "\")";
            VariableQuery query = new VariableQuery();
            query.setLanguage(bpelProcess.getQueryLanguage());
            query.setNamespaces(BpelUtil.getAllNameSpaces(fromToElement));
            query.setText(queryString);
            fromTo.setVariableQuery(query);
            fromToFullDefinition.setVariant(Variant.PROP);
        } else if (fromTo.getPartnerLink() != null) {
            fromToFullDefinition.setVariant(Variant.PLNK);
            fromTo.setVariant(Variant.PLNK);
        } else if (fromTo instanceof To || fromTo instanceof From && ((From)fromTo).getLiteral() == null) {
            fromTo.setVariant(Variant.EXPR);
            Expression expression = new Expression();
            String expressionLanguage = XmlUtil.attribute(fromToElement, "expressionLanguage");
            if (expressionLanguage == null) {
                expressionLanguage = bpelProcess.getExpressionLanguage();
            }
            if (!EvaluatorFactory.isSupportedLanguage(expressionLanguage)) {
                String message = StaticAnalysisFault.getMessage("SA00004", "  Expression language '" + expressionLanguage + "' not supported.");
                parse.addProblem(message, new StaticAnalysisException("SA00004"), fromToElement);
            }
            expression.setLanguage(expressionLanguage);
            expression.setNamespaces(BpelUtil.getAllNameSpaces(fromToElement));
            expression.setText(fromToElement.getTextContent());
            fromTo.setExpression(expression);
            fromToFullDefinition.setVariant(Variant.EXPR);
            fromToFullDefinition.setExpression(fromTo.getExpression().getText());
            fromToFullDefinition.setExpressionLanguage(expressionLanguage);
        }
    }

    protected static Literal parseLiteral(Element literalElement) {
        Literal literal = new Literal();
        Element value = null;
        List<Element> elements = XmlUtil.elements(literalElement);
        if (elements.size() > 1) {
            throw new OrchestraRuntimeException("Invalid literal element : it has more than one element child");
        }
        if (elements.size() == 1) {
            Document doc = XmlUtil.getNewDocument();
            doc.appendChild(doc.importNode(elements.get(0), true));
            value = doc.getDocumentElement();
        }
        if (value == null) {
            NodeList nodeChilds = literalElement.getChildNodes();
            String data = null;
            for (int i = 0; i < nodeChilds.getLength(); ++i) {
                org.w3c.dom.Node node = nodeChilds.item(i);
                if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
                data = ((Text)node).getData();
                value = BpelXmlUtil.createElementWithContent(data);
                break;
            }
        }
        if (value == null) {
            value = BpelXmlUtil.createElementWithContent("");
        }
        literal.setValue(value);
        return literal;
    }

    @Override
    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new AssignActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

