/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.RepeatUntil;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.full.RepeatUntilActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.RepeatUntilActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.lang.evaluator.EvaluatorFactory;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.parsing.binding.IfBinding;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Element;

public class RepeatUntilBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(IfBinding.class.getName());

    public RepeatUntilBinding() {
        super("repeatUntil", ActivityType.REPEAT_UNTIL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(Element element, Parse parse, Parser parser) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        RepeatUntil repeatUntil = new RepeatUntil();
        this.setEnclosingScope(repeatUntil, parse);
        this.parseStandardAttributes(element, repeatUntil, parse);
        this.parseStandardElements(element, repeatUntil, parse);
        Node repeatUntilNode = this.createActivityNode(parse, parser, repeatUntil);
        parse.pushObject(repeatUntilNode);
        parse.pushObject(repeatUntil);
        try {
            repeatUntil.setCondition(this.parseCondition(element, parse));
            this.parseChildActivity(element, parse, parser);
        }
        finally {
            parse.popObject();
            parse.popObject();
        }
        return repeatUntilNode;
    }

    private Expression parseCondition(Element parentElement, Parse parse) {
        Element conditionElement = XmlUtil.element(parentElement, "condition");
        if (conditionElement != null) {
            BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
            String expressionLanguage = XmlUtil.attribute(conditionElement, "expressionLanguage");
            if (expressionLanguage == null) {
                expressionLanguage = bpelProcess.getExpressionLanguage();
            }
            Expression expression = new Expression();
            if (!EvaluatorFactory.isSupportedLanguage(expressionLanguage)) {
                String message = StaticAnalysisFault.getMessage("SA00004", "  Expression language '" + expressionLanguage + "' not supported.");
                parse.addProblem(message, new StaticAnalysisException("SA00004"), parentElement);
            }
            expression.setLanguage(expressionLanguage);
            expression.setNamespaces(BpelUtil.getAllNameSpaces(conditionElement));
            String textContent = conditionElement.getTextContent();
            expression.setText(textContent);
            DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
            RepeatUntilActivityFullDefinition activityFullDefinition = (RepeatUntilActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
            activityFullDefinition.setConditionBooleanExpression(textContent);
            activityFullDefinition.setConditionExpressionLanguage(expressionLanguage);
            return expression;
        }
        return null;
    }

    public RepeatUntilActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new RepeatUntilActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

