/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.Rethrow;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.RethrowActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Element;

public class RethrowBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(RethrowBinding.class.getName());

    public RethrowBinding() {
        super("rethrow", ActivityType.RETHROW);
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        Rethrow rethrow = new Rethrow();
        this.setEnclosingScope(rethrow, parse);
        this.parseStandardAttributes(element, rethrow, parse);
        this.parseStandardElements(element, rethrow, parse);
        Node activityNode = this.createActivityNode(parse, parser, rethrow);
        boolean foundCatchOrCatchAll = false;
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        for (Object e : definitionKeeper.getParentsStack()) {
            ActivityDefinition parentActivity = (ActivityDefinition)e;
            ActivityType parentActivityType = parentActivity.getType();
            if (parentActivityType != ActivityType.CATCH_HANDLER && parentActivityType != ActivityType.CATCHALL_HANDLER) continue;
            foundCatchOrCatchAll = true;
            break;
        }
        if (!foundCatchOrCatchAll) {
            String message = StaticAnalysisFault.getMessage("SA00006", "  The <rethrow> element \"" + rethrow.getName() + "\" is not in a <catch> or <catchAll> element.");
            parse.addProblem(message, new StaticAnalysisException("SA00006"), element);
            return null;
        }
        return activityNode;
    }

    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new RethrowActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

