/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.Wait;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.WaitActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.WaitActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.ForDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.UntilDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.parsing.binding.PickBinding;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Element;

public class WaitBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(WaitBinding.class.getName());

    public WaitBinding() {
        super("wait", ActivityType.WAIT);
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        Wait waitObject = new Wait();
        this.setEnclosingScope(waitObject, parse);
        this.parseStandardAttributes(element, waitObject, parse);
        Node waitNode = this.createActivityNode(parse, parser, waitObject);
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        ForDefinitionImpl forDefinition = new ForDefinitionImpl();
        UntilDefinitionImpl untilDefinition = new UntilDefinitionImpl();
        this.parseStandardElements(element, waitObject, parse);
        BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
        Element deadlineElement = XmlUtil.element(element, "until");
        Element durationElement = XmlUtil.element(element, "for");
        if (durationElement != null && deadlineElement != null) {
            parse.addProblem("Error in element: " + element + " only one element 'for' or 'until' should be used.", element);
        }
        if (durationElement != null) {
            Expression expression = PickBinding.parseExpression(durationElement, bpelProcess, parse);
            waitObject.setDurationExpression(expression);
            forDefinition = new ForDefinitionImpl(expression.getLanguage(), expression.getText());
        } else if (deadlineElement != null) {
            Expression expression = PickBinding.parseExpression(deadlineElement, bpelProcess, parse);
            waitObject.setDeadlineExpression(expression);
            untilDefinition = new UntilDefinitionImpl(expression.getLanguage(), expression.getText());
        } else {
            parse.addProblem("Error in element: " + element + " one element 'for' or 'until' should be used.", element);
        }
        ((WaitActivityFullDefinition)activityFullDefinition).addForDefinition(forDefinition);
        ((WaitActivityFullDefinition)activityFullDefinition).addUntilDefinition(untilDefinition);
        return waitNode;
    }

    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new WaitActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

