/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.data.runtime.ActivityInstanceData;
import org.ow2.orchestra.facade.data.runtime.BpelFaultData;
import org.ow2.orchestra.facade.data.runtime.CorrelationSetInitializedData;
import org.ow2.orchestra.facade.data.runtime.ForeachInitializedData;
import org.ow2.orchestra.facade.data.runtime.PartnerLinkUpdateData;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.data.runtime.ScopeStateUpdateData;
import org.ow2.orchestra.facade.data.runtime.TimerData;
import org.ow2.orchestra.facade.data.runtime.TransitionConditionUpdateData;
import org.ow2.orchestra.facade.data.runtime.VariableUpdateData;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ActivityWithChildrenFullInstance;
import org.ow2.orchestra.facade.runtime.full.ActivityWithSingleChildFullInstance;
import org.ow2.orchestra.facade.runtime.full.CompensationHandlerActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.FlowActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ForeachActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.PickActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.full.ScopeActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.TerminationHandlerActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.WaitActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.impl.ActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.AssignActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CatchActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CatchAllActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CompensateActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CompensateScopeActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CompensationHandlerActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.CorrelationSetInitializationFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.EmptyActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ExitActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.FlowActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ForeachActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.IfActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.InvokeActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.PartnerLinkUpdateFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.PickActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ProcessFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ProcessInstanceStateUpdateFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ReceiveActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.RepeatUntilActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ReplyActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.RethrowActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ScopeActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ScopeStateUpdateFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.SequenceActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.TerminationHandlerActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.ThrowActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.TransitionConditionUpdateFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.UnknownActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.VariableUpdateFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.WaitActivityFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.WaitingActivityFullImpl;
import org.ow2.orchestra.facade.runtime.full.impl.WhileActivityFullInstanceImpl;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.db.DbRecorder;
import org.ow2.orchestra.persistence.db.QuerierDbSession;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbQuerier
implements Querier {
    protected QuerierDbSession querierDbSession;

    public DbQuerier(QuerierDbSession querierDbSession) {
        this.querierDbSession = querierDbSession;
    }

    protected Map<ActivityInstanceUUID, ActivityFullInstance> getProcessInstanceActivities(ProcessInstanceUUID instanceUUID, boolean remove) {
        List<DbRecorder.Record> records = this.getQuerierDbSession().getAllRecords(instanceUUID);
        ProcessFullInstance processFullInstance = null;
        HashMap<ActivityInstanceUUID, ActivityFullInstance> activities = new HashMap<ActivityInstanceUUID, ActivityFullInstance>();
        for (DbRecorder.Record record : records) {
            processFullInstance = this.processRecord(processFullInstance, activities, record, true);
            if (!remove) continue;
            this.getQuerierDbSession().delete(record);
        }
        for (ActivityInstanceUUID activityInstanceUUID : activities.keySet()) {
            List<DbRecorder.Record> actRecords = this.getQuerierDbSession().getAllActivityRecords(activityInstanceUUID);
            for (DbRecorder.Record record : actRecords) {
                if (record.getProcessInstanceUUID() == null) {
                    processFullInstance = this.processRecord(processFullInstance, activities, record, true);
                }
                if (!remove) continue;
                this.getQuerierDbSession().delete(record);
            }
        }
        return activities;
    }

    protected QuerierDbSession getQuerierDbSession() {
        return this.querierDbSession;
    }

    private ProcessFullInstance processRecord(ProcessFullInstance processFullInstance, Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record, boolean complete) {
        switch (record.getType()) {
            case instanceStarted: {
                processFullInstance = this.processInstanceStarted(activities, record);
                break;
            }
            case instanceEnded: {
                this.processInstanceEnded(processFullInstance, record);
                break;
            }
            case instanceUpdated: {
                this.processInstanceUpdated(processFullInstance, record);
                break;
            }
            case activityStarted: {
                this.processActivityStarted(activities, record, complete);
                break;
            }
            case activityEnded: {
                this.processActivityEnded(activities, record);
                break;
            }
            case activityExited: {
                this.processActivityExited(activities, record);
                break;
            }
            case activityTerminated: {
                this.processActivityTerminated(activities, record);
                break;
            }
            case exceptionOccured: {
                this.processExceptionOccured(activities, record);
                break;
            }
            case timerStarted: {
                this.processTimerStarted(activities, record);
                break;
            }
            case eventStarted: {
                this.processEventStarted(activities, record);
                break;
            }
            case correlationSetInitialized: {
                this.processCorrelationSetInitialized(activities, record);
                break;
            }
            case foreachInitialized: {
                this.processForEachInitialized(activities, record);
                break;
            }
            case partnerLinkUpdated: {
                this.processPartnerLinkUpdated(activities, record);
                break;
            }
            case scopeStateChanged: {
                this.processScopeStateChanged(activities, record);
                break;
            }
            case transitionConditionUpdated: {
                this.processTransitionConditionUpdated(activities, record);
                break;
            }
            case variableUpdated: {
                this.processVariableUpdated(activities, record);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown type " + (Object)((Object)record.getType()));
            }
        }
        return processFullInstance;
    }

    private void processVariableUpdated(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        VariableUpdateData variableUpdateData = (VariableUpdateData)record.getData();
        ScopeActivityFullInstance scopeActivityFullInstance = (ScopeActivityFullInstance)activities.get(variableUpdateData.getScopeActivityUUID());
        VariableUpdateFullImpl varFullUpdate = new VariableUpdateFullImpl(scopeActivityFullInstance, variableUpdateData.getActivityUUID(), variableUpdateData.getDate(), variableUpdateData.getName(), variableUpdateData.getValue());
        scopeActivityFullInstance.getVariables().add(varFullUpdate);
        varFullUpdate.setIndex(scopeActivityFullInstance.getVariables().indexOf(varFullUpdate));
    }

    private void processTransitionConditionUpdated(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        TransitionConditionUpdateData transitionConditionUpdateData = (TransitionConditionUpdateData)record.getData();
        FlowActivityFullInstance flowActivityFullInstance = (FlowActivityFullInstance)activities.get(transitionConditionUpdateData.getFlowActivityUUID());
        flowActivityFullInstance.getTransitionConditionUpdateList().add(new TransitionConditionUpdateFullImpl(transitionConditionUpdateData.getStatus(), transitionConditionUpdateData.getName(), transitionConditionUpdateData.getDate()));
    }

    private void processScopeStateChanged(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        ScopeStateUpdateData scopeStateUpdateData = (ScopeStateUpdateData)record.getData();
        ScopeActivityFullInstance scopeActivityFullInstance = (ScopeActivityFullInstance)activities.get(scopeStateUpdateData.getScopeActivityUUID());
        scopeActivityFullInstance.getScopeState().add(new ScopeStateUpdateFullImpl(scopeStateUpdateData.getActivityUUID(), scopeStateUpdateData.getDate(), scopeStateUpdateData.getState()));
    }

    private void processPartnerLinkUpdated(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        PartnerLinkUpdateData partnerLinkUpdateData = (PartnerLinkUpdateData)record.getData();
        ScopeActivityFullInstance scopeActivityFullInstance = (ScopeActivityFullInstance)activities.get(partnerLinkUpdateData.getScopeActivityUUID());
        if (scopeActivityFullInstance.getPartnerLink() == null) {
            Misc.unreachableStatement();
        }
        scopeActivityFullInstance.getPartnerLink().add(new PartnerLinkUpdateFullImpl(partnerLinkUpdateData.getActivityUUID(), partnerLinkUpdateData.getDate(), partnerLinkUpdateData.getName(), partnerLinkUpdateData.getPartnerLinkUpdateType(), partnerLinkUpdateData.getPartnerLinkReference()));
    }

    private void processForEachInitialized(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        ForeachInitializedData foreachInitializedData = (ForeachInitializedData)record.getData();
        ForeachActivityFullInstance foreachActivityFullInstance = (ForeachActivityFullInstance)activities.get(foreachInitializedData.getActivityInstanceUUID());
        foreachActivityFullInstance.update(foreachInitializedData.getStartValue(), foreachInitializedData.getStopValue(), foreachInitializedData.getCompletionConditionValue());
    }

    private void processCorrelationSetInitialized(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        CorrelationSetInitializedData correlationSetInitializedData = (CorrelationSetInitializedData)record.getData();
        ScopeActivityFullInstance scopeActivityFullInstance = (ScopeActivityFullInstance)activities.get(correlationSetInitializedData.getScopeActivityUUID());
        scopeActivityFullInstance.getCorrelationSet().add(new CorrelationSetInitializationFullImpl(correlationSetInitializedData.getActivityUUID(), correlationSetInitializedData.getDate(), correlationSetInitializedData.getName(), correlationSetInitializedData.getPropertyValues()));
    }

    private void processEventStarted(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        ActivityInstanceData activityInstanceData = (ActivityInstanceData)record.getData();
        ProcessDefinitionUUID processUUID = activityInstanceData.getActivityDefinitionData().getProcessDefinitionData().getUUID();
        ProcessInstanceUUID instanceUUID = activityInstanceData.getProcessInstanceData().getUUID();
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        ActivityDefinitionUUID activityDefinitionUUID = activityInstanceData.getActivityDefinitionData().getUUID();
        ActivityInstanceUUID encloserInstanceUUID = activityInstanceData.getEncloserUUID();
        Misc.checkArgsNotNull(processUUID, instanceUUID, activityUUID);
        ScopeActivityFullInstanceImpl activityFullInstance = new ScopeActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, activityInstanceData.getDate());
        activities.put(activityUUID, activityFullInstance);
        if (encloserInstanceUUID == null) {
            Misc.unreachableStatement("EncloserUUID cannot be null");
        } else if (encloserInstanceUUID.equals(activityFullInstance.getUUID())) {
            Misc.unreachableStatement("EncloserUUID (" + encloserInstanceUUID + ") cannot have the same UUID that the activityFullInstance (" + activityFullInstance.getUUID());
        } else {
            ActivityFullInstance encloserActivityFullInstance = activities.get(encloserInstanceUUID);
            ((ScopeActivityFullInstance)encloserActivityFullInstance).addEventInstance(activityFullInstance);
        }
    }

    private void processTimerStarted(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        TimerData timerData = (TimerData)record.getData();
        ActivityFullInstance activityFullInstance = activities.get(timerData.getActivityInstanceUUID());
        WaitingActivityFullImpl waitingActivity = new WaitingActivityFullImpl(timerData.getActivityDefinitionUUID(), timerData.getExpectedStartedDate());
        switch (activityFullInstance.getType()) {
            case PICK: {
                ((PickActivityFullInstance)activityFullInstance).addWaitingActivity(waitingActivity);
                break;
            }
            case WAIT: {
                WaitActivityFullInstance waitActivityFullInstance = (WaitActivityFullInstance)activityFullInstance;
                Misc.badStateIfNotNull(waitActivityFullInstance.getWaitingActivity(), "wait can only own one timer");
                waitActivityFullInstance.setWaitingActivity(waitingActivity);
                break;
            }
            case PROCESS: 
            case SCOPE: {
                break;
            }
            default: {
                Misc.unreachableStatement("Only wait and pick activity can own timers, not " + (Object)((Object)activityFullInstance.getType()));
            }
        }
    }

    private void processExceptionOccured(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        BpelFaultData bpelFaultData = (BpelFaultData)record.getData();
        ActivityFullInstance activityFullInstance = activities.get(bpelFaultData.getActivityInstanceUUID());
        activityFullInstance.setLastException(bpelFaultData.getBpelFault().fullCopy());
    }

    private void processActivityTerminated(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        ActivityInstanceData activityInstanceData = (ActivityInstanceData)record.getData();
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        ActivityFullInstance activityFullInstance = activities.get(activityUUID);
        activityFullInstance.end(ActivityState.TERMINATED, activityInstanceData.getDate());
    }

    private void processActivityExited(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        ActivityInstanceData activityInstanceData = (ActivityInstanceData)record.getData();
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        ActivityFullInstance activityFullInstance = activities.get(activityUUID);
        activityFullInstance.end(ActivityState.EXITED, activityInstanceData.getDate());
    }

    private void processActivityEnded(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        ActivityInstanceData activityInstanceData = (ActivityInstanceData)record.getData();
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        ActivityFullInstance activityFullInstance = activities.get(activityUUID);
        activityFullInstance.end(ActivityState.FINISHED, activityInstanceData.getDate());
    }

    private void processActivityStarted(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record, boolean complete) {
        ActivityFullInstanceImpl activityFullInstance;
        ActivityInstanceData activityInstanceData = (ActivityInstanceData)record.getData();
        ProcessDefinitionUUID processUUID = activityInstanceData.getActivityDefinitionData().getProcessDefinitionData().getUUID();
        ProcessInstanceUUID instanceUUID = activityInstanceData.getProcessInstanceData().getUUID();
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        ActivityDefinitionUUID activityDefinitionUUID = activityInstanceData.getActivityDefinitionData().getUUID();
        ActivityInstanceUUID encloserInstanceUUID = activityInstanceData.getEncloserUUID();
        Misc.checkArgsNotNull(processUUID, instanceUUID, activityUUID);
        Date startedDate = activityInstanceData.getDate();
        ActivityType activityType = activityInstanceData.getActivityDefinitionData().getType();
        switch (activityType) {
            case ASSIGN: {
                activityFullInstance = new AssignActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case CATCH_HANDLER: {
                activityFullInstance = new CatchActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case CATCHALL_HANDLER: {
                activityFullInstance = new CatchAllActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case TERMINATION_HANDLER: {
                activityFullInstance = new TerminationHandlerActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case COMPENSATION_HANDLER: {
                activityFullInstance = new CompensationHandlerActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case SCOPE: {
                activityFullInstance = new ScopeActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case PROCESS: {
                activityFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID, startedDate);
                break;
            }
            case SEQUENCE: {
                activityFullInstance = new SequenceActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case RECEIVE: {
                activityFullInstance = new ReceiveActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case REPLY: {
                activityFullInstance = new ReplyActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case INVOKE: {
                activityFullInstance = new InvokeActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case WAIT: {
                activityFullInstance = new WaitActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case PICK: {
                activityFullInstance = new PickActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case EMPTY: {
                activityFullInstance = new EmptyActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case EXIT: {
                activityFullInstance = new ExitActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case IF: {
                activityFullInstance = new IfActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case REPEAT_UNTIL: {
                activityFullInstance = new RepeatUntilActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case FOR_EACH: {
                activityFullInstance = new ForeachActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case WHILE: {
                activityFullInstance = new WhileActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case FLOW: {
                activityFullInstance = new FlowActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case COMPENSATE: {
                activityFullInstance = new CompensateActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case COMPENSATE_SCOPE: {
                activityFullInstance = new CompensateScopeActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case RETHROW: {
                activityFullInstance = new RethrowActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            case THROW: {
                activityFullInstance = new ThrowActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
                break;
            }
            default: {
                activityFullInstance = new UnknownActivityFullInstanceImpl(activityUUID, activityDefinitionUUID, processUUID, instanceUUID, startedDate);
            }
        }
        activities.put(activityUUID, activityFullInstance);
        if (complete) {
            if (encloserInstanceUUID == null) {
                Misc.unreachableStatement("EncloserUUID cannot be null");
            } else if (encloserInstanceUUID.equals(activityFullInstance.getUUID())) {
                Misc.unreachableStatement("EncloserUUID (" + encloserInstanceUUID + ") cannot have the same UUID that the activityFullInstance (" + activityFullInstance.getUUID());
            } else {
                ActivityFullInstance encloserActivityFullInstance = activities.get(encloserInstanceUUID);
                if (activityType.equals((Object)ActivityType.CATCH_HANDLER) || activityType.equals((Object)ActivityType.CATCHALL_HANDLER)) {
                    ((ScopeActivityFullInstance)encloserActivityFullInstance).setFaultHandlerActivityInstance((ActivityWithSingleChildFullInstance)((Object)activityFullInstance));
                } else if (activityType.equals((Object)ActivityType.TERMINATION_HANDLER)) {
                    ((ScopeActivityFullInstance)encloserActivityFullInstance).setTerminationHandlerActivityInstance((TerminationHandlerActivityFullInstance)((Object)activityFullInstance));
                } else if (activityType.equals((Object)ActivityType.COMPENSATION_HANDLER)) {
                    ((ScopeActivityFullInstance)encloserActivityFullInstance).setCompensationHandlerActivityInstance((CompensationHandlerActivityFullInstance)((Object)activityFullInstance));
                } else if (encloserActivityFullInstance.isChildrenActivity()) {
                    ((ActivityWithChildrenFullInstance)encloserActivityFullInstance).addEnclosedActivity(activityFullInstance);
                } else if (encloserActivityFullInstance.isSingleChildActivity()) {
                    ((ActivityWithSingleChildFullInstance)encloserActivityFullInstance).setEnclosedActivity(activityFullInstance);
                } else {
                    Misc.unreachableStatement("EncloserUUID (" + encloserInstanceUUID + ") has no possible enclosed activity. " + "It cannot be the parent of activityFullInstance (" + activityFullInstance.getUUID());
                }
            }
        }
    }

    private void processInstanceUpdated(ProcessFullInstance processFullInstance, DbRecorder.Record record) {
        ProcessInstanceData processInstanceData = (ProcessInstanceData)record.getData();
        processFullInstance.addProcessInstanceState(new ProcessInstanceStateUpdateFullImpl(processInstanceData.getDate(), processInstanceData.getState()));
    }

    private void processInstanceEnded(ProcessFullInstance processFullInstance, DbRecorder.Record record) {
        ProcessInstanceData processInstanceData = (ProcessInstanceData)record.getData();
        this.processInstanceUpdated(processFullInstance, record);
        processFullInstance.end(processInstanceData.getState(), processInstanceData.getDate());
    }

    private ProcessFullInstance processInstanceStarted(Map<ActivityInstanceUUID, ActivityFullInstance> activities, DbRecorder.Record record) {
        ProcessInstanceData processInstanceData = (ProcessInstanceData)record.getData();
        ProcessDefinitionUUID processUUID = processInstanceData.getProcessDefinitionData().getUUID();
        ProcessInstanceUUID instanceUUID = processInstanceData.getUUID();
        Misc.checkArgsNotNull(processUUID, instanceUUID);
        ProcessFullInstanceImpl processFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID, processInstanceData.getDate());
        processFullInstance.addProcessInstanceState(new ProcessInstanceStateUpdateFullImpl(processInstanceData.getDate(), processInstanceData.getState()));
        activities.put(instanceUUID, processFullInstance);
        return processFullInstance;
    }

    @Override
    public Set<ActivityFullInstance> findActivityInstances(ProcessInstanceUUID instanceUUID) {
        return new HashSet<ActivityFullInstance>(this.getProcessInstanceActivities(instanceUUID, false).values());
    }

    @Override
    public Set<ActivityFullInstance> findActivityInstances(ProcessInstanceUUID instanceUUID, ActivityState activityState) {
        HashSet<ActivityFullInstance> result = new HashSet<ActivityFullInstance>();
        for (ActivityFullInstance activity : this.getProcessInstanceActivities(instanceUUID, false).values()) {
            if (!activity.getState().equals((Object)activityState)) continue;
            result.add(activity);
        }
        return result;
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances() {
        Collection<ProcessInstanceUUID> instanceUUIDs = this.getQuerierDbSession().getAllProcessInstanceUUIDsFromRecords();
        HashSet<ProcessFullInstance> result = new HashSet<ProcessFullInstance>();
        for (ProcessInstanceUUID instanceUUID : instanceUUIDs) {
            if (instanceUUID == null) continue;
            result.add(this.getProcessInstance(instanceUUID));
        }
        return result;
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID) {
        Collection<ProcessInstanceUUID> instanceUUIDs = this.getQuerierDbSession().getAllProcessInstanceUUIDsFromRecords(processDefinitionUUID);
        HashSet<ProcessFullInstance> result = new HashSet<ProcessFullInstance>();
        for (ProcessInstanceUUID instanceUUID : instanceUUIDs) {
            if (instanceUUID == null) continue;
            result.add(this.getProcessInstance(instanceUUID));
        }
        return result;
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) {
        Collection<ProcessInstanceUUID> instanceUUIDs = this.getQuerierDbSession().getAllProcessInstanceUUIDsFromRecords(processDefinitionUUID);
        HashSet<ProcessFullInstance> result = new HashSet<ProcessFullInstance>();
        for (ProcessInstanceUUID instanceUUID : instanceUUIDs) {
            ProcessFullInstance processFullInstance;
            if (instanceUUID == null || !(processFullInstance = this.getProcessInstance(instanceUUID)).getState().equals((Object)processInstanceState)) continue;
            result.add(processFullInstance);
        }
        return result;
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances(ActivityState processInstanceState) {
        Collection<ProcessInstanceUUID> instanceUUIDs = this.getQuerierDbSession().getAllProcessInstanceUUIDsFromRecords();
        HashSet<ProcessFullInstance> result = new HashSet<ProcessFullInstance>();
        for (ProcessInstanceUUID instanceUUID : instanceUUIDs) {
            ProcessFullInstance processFullInstance;
            if (instanceUUID == null || !(processFullInstance = this.getProcessInstance(instanceUUID)).getState().equals((Object)processInstanceState)) continue;
            result.add(processFullInstance);
        }
        return result;
    }

    @Override
    public ActivityFullInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) {
        HashMap<ActivityInstanceUUID, ActivityFullInstance> activities = new HashMap<ActivityInstanceUUID, ActivityFullInstance>();
        List<DbRecorder.Record> actRecords = this.getQuerierDbSession().getAllActivityRecords(activityInstanceUUID);
        for (DbRecorder.Record record : actRecords) {
            this.processRecord(null, activities, record, false);
        }
        return null;
    }

    @Override
    public ProcessFullInstance getProcessInstance(ProcessInstanceUUID instanceUUID) {
        return (ProcessFullInstance)this.getProcessInstanceActivities(instanceUUID, false).get(instanceUUID);
    }

    @Override
    public ActivityFullDefinition getActivityDefinition(ActivityDefinitionUUID activityDefinitionUUID) {
        return this.getQuerierDbSession().getActivityDefinition(activityDefinitionUUID);
    }

    @Override
    public Set<ActivityFullDefinition> findActivityDefinitions(ProcessDefinitionUUID processUUID) {
        return this.getQuerierDbSession().findActivityDefinitions(processUUID);
    }

    @Override
    public ProcessFullDefinition getProcessDefinition(ProcessDefinitionUUID processDefinitionUUID) {
        return this.getQuerierDbSession().getProcessDefinition(processDefinitionUUID);
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions(QName name, ProcessState state) {
        return this.getQuerierDbSession().findProcessDefinition(name, state);
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions(QName name) {
        return this.getQuerierDbSession().findProcessDefinition(name);
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions(ProcessState state) {
        return this.getQuerierDbSession().findProcessDefinition(state);
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions() {
        return this.getQuerierDbSession().findProcessDefinition();
    }

    @Override
    public ProcessFullDefinition removeProcessDefinition(ProcessDefinitionUUID processDefinitionUUID) {
        ProcessFullDefinition processFullDefinition = this.getProcessDefinition(processDefinitionUUID);
        if (processFullDefinition != null) {
            this.getQuerierDbSession().delete(processFullDefinition);
            return processFullDefinition.fullCopy();
        }
        return null;
    }

    @Override
    public ProcessFullInstance removeProcessInstance(ProcessInstanceUUID instanceUUID) {
        return (ProcessFullInstance)this.getProcessInstanceActivities(instanceUUID, true).get(instanceUUID);
    }
}

