/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db.hibernate;

import java.io.Serializable;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.ow2.orchestra.persistence.db.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateDbSession
implements DbSession {
    protected Session session;

    public void close() {
        this.session.close();
    }

    @Override
    public <T> T get(Class<T> entityClass, Object primaryKey) {
        return entityClass.cast(this.session.get(entityClass, (Serializable)primaryKey));
    }

    @Override
    public void flush() {
        this.session.flush();
    }

    @Override
    public void forceVersionUpdate(Object entity) {
        this.session.buildLockRequest(null).setLockMode(LockMode.NONE).lock(entity);
    }

    @Override
    public void lockPessimistically(Object entity) {
        this.session.buildLockRequest(null).setLockMode(LockMode.PESSIMISTIC_WRITE).lock(entity);
    }

    @Override
    public void save(Object entity) {
        this.session.persist(entity);
    }

    @Override
    public void delete(Object entity) {
        this.session.delete(entity);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

