/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.Query;
import org.ow2.orchestra.persistence.db.hibernate.HibernateDbSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.BpelInstance;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateJobDbSession
extends HibernateDbSession
implements JobDbSession {
    @Override
    public Collection<JobImpl<?>> findFirstAcquirableJob(int limit, boolean limitSameInstanceJobs) {
        Query query = limitSameInstanceJobs ? this.session.getNamedQuery("findFirstAcquirableJobExclusiveInstance") : this.session.getNamedQuery("findFirstAcquirableJob");
        query.setTimestamp("now", Clock.getCurrentTime());
        query.setMaxResults(limit);
        return query.list();
    }

    public List<JobImpl<?>> findExclusiveJobs(BpelInstance processInstance) {
        Query query = this.session.getNamedQuery("findExclusiveJobs");
        query.setTimestamp("now", Clock.getCurrentTime());
        query.setEntity("processInstance", (Object)processInstance);
        return query.list();
    }

    @Override
    public JobImpl<?> findFirstDueJob() {
        Query query = this.session.getNamedQuery("findFirstDueJob");
        query.setMaxResults(1);
        query.setReadOnly(true);
        return (JobImpl)query.uniqueResult();
    }

    @Override
    public JobImpl<?> getJob(long jobId) {
        return (JobImpl)JobImpl.class.cast(this.session.get(JobImpl.class, (Serializable)Long.valueOf(jobId)));
    }

    @Override
    public void save(Object entity) {
        if (entity instanceof JobImpl) {
            this.save((JobImpl)entity);
        } else {
            super.save(entity);
        }
    }

    public void save(JobImpl<?> job) {
        if (job.getExecution() != null) {
            job.getExecution().getJobs().add(job);
        }
        super.save(job);
    }

    @Override
    public void delete(Object entity) {
        if (entity instanceof JobImpl) {
            this.delete((JobImpl)entity);
        } else {
            super.delete(entity);
        }
    }

    public void delete(JobImpl<?> job) {
        BpelExecution jobExecution = job.getExecution();
        if (jobExecution != null) {
            jobExecution.getJobs().remove(job);
        }
        super.delete(job);
    }
}

