/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.data.def.ProcessDefinitionData;
import org.ow2.orchestra.facade.data.runtime.ActivityInstanceData;
import org.ow2.orchestra.facade.data.runtime.BpelFaultData;
import org.ow2.orchestra.facade.data.runtime.CorrelationSetInitializedData;
import org.ow2.orchestra.facade.data.runtime.ForeachInitializedData;
import org.ow2.orchestra.facade.data.runtime.PartnerLinkUpdateData;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.data.runtime.ScopeStateUpdateData;
import org.ow2.orchestra.facade.data.runtime.TimerData;
import org.ow2.orchestra.facade.data.runtime.TransitionConditionUpdateData;
import org.ow2.orchestra.facade.data.runtime.VariableUpdateData;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.persistence.Transaction;
import org.ow2.orchestra.services.Archivable;
import org.ow2.orchestra.services.Recorder;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Node;

public class LoggerRecorder
implements Recorder {
    private static final Logger LOG = Logger.getLogger(LoggerRecorder.class.getName());
    private final Level level;

    public LoggerRecorder() {
        this(Level.FINE);
    }

    public LoggerRecorder(String levelName) {
        this(Level.parse(levelName));
    }

    public LoggerRecorder(Level level) {
        this.level = level;
        if (LOG.isLoggable(this.level)) {
            Transaction tx = Environment.getFromCurrent(Transaction.class);
            tx.registerSynchronization(new LoggerRecorderSynchronization(level));
        }
    }

    public void recordInstanceStarted(ProcessInstanceData processInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Start [uuid:" + processInstanceData.getUUID() + "] an instance of process named '{" + processInstanceData.getProcessDefinitionData().getNameSpace() + "}" + processInstanceData.getProcessDefinitionData().getName() + "'");
        }
    }

    public void recordInstanceEnded(ProcessInstanceData processInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Instance [uuid:" + processInstanceData.getUUID() + "] ended");
        }
    }

    public void recordInstanceUpdated(ProcessInstanceData processInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Instance [uuid:" + processInstanceData.getUUID() + "] " + processInstanceData.getState().toString().toLowerCase());
        }
    }

    public void recordActivityStarted(ActivityInstanceData activityInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Start [uuid:" + activityInstanceData.getUUID() + "] an activity of an instance of process named {" + activityInstanceData.getActivityDefinitionData().getProcessDefinitionData().getNameSpace() + "}" + activityInstanceData.getActivityDefinitionData().getProcessDefinitionData().getName() + ", this " + (Object)((Object)activityInstanceData.getActivityDefinitionData().getType()) + " activity name is '" + activityInstanceData.getActivityDefinitionData().getName() + "'");
        }
    }

    public void recordEventStarted(ActivityInstanceData activityInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Start [uuid:" + activityInstanceData.getUUID() + "] an event of an instance of process named {" + activityInstanceData.getActivityDefinitionData().getProcessDefinitionData().getNameSpace() + "}" + activityInstanceData.getActivityDefinitionData().getProcessDefinitionData().getName() + ", this " + (Object)((Object)activityInstanceData.getActivityDefinitionData().getType()) + " activity name is '" + activityInstanceData.getActivityDefinitionData().getName() + "'");
        }
    }

    public void recordExceptionOccured(BpelFaultData bpelFaultData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity [uuid:" + bpelFaultData.getActivityInstanceUUID() + "] has thrown an exception: " + bpelFaultData.getBpelFault());
        }
    }

    public void recordActivityEnded(ActivityInstanceData activityInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity [uuid:" + activityInstanceData.getUUID() + "] ended");
        }
    }

    public void recordActivityExited(ActivityInstanceData activityInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity [uuid:" + activityInstanceData.getUUID() + "] exited");
        }
    }

    public void recordActivityTerminated(ActivityInstanceData activityInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity [uuid:" + activityInstanceData.getUUID() + "] terminated");
        }
    }

    public void remove(Archivable archivable) {
        if (archivable instanceof ProcessFullInstance) {
            this.remove((ProcessFullInstance)archivable);
        } else if (archivable instanceof ProcessFullDefinition) {
            this.remove((ProcessFullDefinition)archivable);
        }
    }

    public void remove(ProcessFullInstance processFullInstance) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "ProcessInstance " + processFullInstance.getUUID() + " removed.");
        }
    }

    public void remove(ProcessFullDefinition processFullDefinition) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Process " + processFullDefinition.getUUID() + " removed.");
        }
    }

    public void recordTimerStarted(TimerData timerData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Timer [expectedStartedDate: " + timerData.getExpectedStartedDate() + "] started for activity " + timerData.getActivityInstanceUUID());
        }
    }

    public void recordForeachInitialized(ForeachInitializedData foreachInitializedData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Foreach [startValue: " + foreachInitializedData.getStartValue() + "]" + "[stopValue: " + foreachInitializedData.getStopValue() + "]");
        }
    }

    public void recordVariableUpdated(VariableUpdateData variableUpdateData) {
        if (LOG.isLoggable(this.level)) {
            String variableValueAsString = null;
            Object variableValue = variableUpdateData.getValue();
            variableValueAsString = variableValue instanceof Node ? XmlUtil.toString((Node)variableValue) : variableValue.toString();
            LOG.log(this.level, "Variable [name: " + variableUpdateData.getName() + ", scopeUUID: " + variableUpdateData.getScopeActivityUUID() + "] is set to [" + variableValueAsString + "] by activity " + variableUpdateData.getActivityUUID());
        }
    }

    public void recordCorrelationSetInitialized(CorrelationSetInitializedData correlationSetInitializedData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Correlation set [name: " + correlationSetInitializedData.getName() + ", scopeUUID: " + correlationSetInitializedData.getScopeActivityUUID() + "] is initialized by activity " + correlationSetInitializedData.getActivityUUID());
        }
    }

    public void recordPartnerLinkUpdated(PartnerLinkUpdateData partnerLinkUpdateData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Partner Link [name: " + partnerLinkUpdateData.getName() + ", scopeUUID: " + partnerLinkUpdateData.getScopeActivityUUID() + "] is updated by activity " + partnerLinkUpdateData.getActivityUUID());
        }
    }

    public void recordTransitionConditionUpdated(TransitionConditionUpdateData transitionConditionUpdateData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Transition Condition [name: " + transitionConditionUpdateData.getName() + ", status: " + transitionConditionUpdateData.getStatus() + ", flow activity UUID " + transitionConditionUpdateData.getFlowActivityUUID() + "]");
        }
    }

    public void recordScopeStateChanged(ScopeStateUpdateData scopeStateUpdateData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Scope State Update [state: " + (Object)((Object)scopeStateUpdateData.getState()) + ", scope activity UUID " + scopeStateUpdateData.getScopeActivityUUID() + "]");
        }
    }

    public void recordProcessDeployed(ProcessFullDefinition processFullDefinition) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Deploy process [name: " + processFullDefinition.getName() + ", processUUID " + processFullDefinition.getUUID() + "]");
        }
    }

    public void recordProcessUndeployed(ProcessDefinitionUUID processDefinitionUUID) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Undeploy process [processUUID " + processDefinitionUUID + "]");
        }
    }

    public void recordProcessStateChanged(ProcessDefinitionData processDefinitionData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Process state changed [name: " + processDefinitionData.getName() + ", processUUID: " + processDefinitionData.getUUID() + ", state: " + (Object)((Object)processDefinitionData.getState()) + "]");
        }
    }

    private static final class LoggerRecorderSynchronization
    implements Synchronization {
        private final Level level;

        private LoggerRecorderSynchronization(Level level) {
            this.level = level;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                LOG.log(this.level, "Transaction committed");
            } else {
                LOG.log(this.level, "Transaction rolledback");
            }
        }
    }
}

