/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.tx;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.ow2.orchestra.persistence.tx.StandardResource;
import org.ow2.orchestra.util.Misc;

public class HibernateSessionResource
implements StandardResource {
    private static final Logger LOG = Logger.getLogger(HibernateSessionResource.class.getName());
    protected Session session;
    protected Transaction transaction;

    public HibernateSessionResource(Session session) {
        this.session = session;
        Misc.fastDynamicLog(LOG, Level.FINEST, "beginning transaction on hibernate session %s", System.identityHashCode(session));
        try {
            this.transaction = session.beginTransaction();
        }
        catch (RuntimeException e) {
            Misc.fastDynamicLog(LOG, Level.SEVERE, "hibernate transaction begin failed. closing hibernate session: %s", e);
            session.close();
            throw e;
        }
        Misc.fastDynamicLog(LOG, Level.FINE, "begun hibernate transaction %s on hibernate session %s", System.identityHashCode(this.transaction), System.identityHashCode(session));
    }

    public void prepare() {
        Misc.fastDynamicLog(LOG, Level.FINE, "flushing hibernate session %s", System.identityHashCode(this.session));
        this.session.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Misc.fastDynamicLog(LOG, Level.FINE, "committing hibernate transaction %s", System.identityHashCode(this.transaction));
        try {
            this.transaction.commit();
        }
        finally {
            this.closeSession();
        }
    }

    private void closeSession() {
        Misc.fastDynamicLog(LOG, Level.FINE, "closing hibernate session %s", System.identityHashCode(this.session));
        this.session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Misc.fastDynamicLog(LOG, Level.FINE, "rolling back hibernate transaction %s", System.identityHashCode(this.transaction));
        try {
            this.transaction.rollback();
        }
        finally {
            this.closeSession();
        }
    }
}

