/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.tx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import org.ow2.orchestra.persistence.Transaction;
import org.ow2.orchestra.persistence.tx.StandardResource;
import org.ow2.orchestra.persistence.tx.StandardSynchronization;
import org.ow2.orchestra.persistence.tx.TransactionException;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTransaction
implements Transaction,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(StandardTransaction.class.getName());
    protected final List<StandardResource> resources = new LinkedList<StandardResource>();
    protected final List<StandardSynchronization> synchronizations = new ArrayList<StandardSynchronization>();
    protected State state = State.CREATED;

    public void begin() {
        Misc.fastDynamicLog(LOG, Level.FINEST, "beginning %s", this);
        this.state = State.ACTIVE;
    }

    public void complete() {
        if (this.state == State.ACTIVE) {
            this.commit();
        } else if (this.state == State.ROLLBACKONLY) {
            this.rollback();
        } else {
            throw new TransactionException("complete on transaction in state " + (Object)((Object)this.state));
        }
    }

    @Override
    public void setRollbackOnly() {
        if (this.state != State.ACTIVE) {
            throw new TransactionException("transaction was not active: " + (Object)((Object)this.state));
        }
        this.state = State.ROLLBACKONLY;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.state == State.ROLLBACKONLY || this.state == State.ROLLEDBACK;
    }

    public void commit() {
        if (this.state != State.ACTIVE) {
            throw new TransactionException("commit on transaction in state " + (Object)((Object)this.state));
        }
        Misc.fastDynamicLog(LOG, Level.FINEST, "committing %s", this);
        try {
            this.beforeCompletion();
            if (this.resources != null) {
                for (StandardResource standardResource : this.resources) {
                    Misc.fastDynamicLog(LOG, Level.FINEST, "preparing resource %s", standardResource);
                    standardResource.prepare();
                }
            }
        }
        catch (RuntimeException exception) {
            try {
                Misc.fastDynamicLog(LOG, Level.FINE, "resource threw exception in prepare. rolling back.", new Object[0]);
                this.rollbackResources();
            }
            catch (Exception rollbackException) {
                Misc.fastDynamicLog(LOG, Level.SEVERE, "rollback failed as well: %s %s", rollbackException, Misc.getStackTraceFrom(rollbackException));
            }
            throw exception;
        }
        Throwable commitException = null;
        if (this.resources != null) {
            for (StandardResource standardResource : this.resources) {
                try {
                    Misc.fastDynamicLog(LOG, Level.FINEST, "committing resource %s", standardResource);
                    standardResource.commit();
                }
                catch (Throwable t) {
                    Misc.fastDynamicLog(LOG, Level.SEVERE, "commit failed for resource %s: %s %s", standardResource, t, Misc.getStackTraceFrom(t));
                    if (commitException != null) continue;
                    commitException = t;
                }
            }
        }
        this.state = State.COMMITTED;
        this.afterCompletion();
        Misc.fastDynamicLog(LOG, Level.FINEST, "committed %s", this);
        if (commitException != null) {
            if (commitException instanceof RuntimeException) {
                throw (RuntimeException)commitException;
            }
            if (commitException instanceof Error) {
                throw (Error)commitException;
            }
            throw new TransactionException("resource failed to commit", commitException);
        }
    }

    public void rollback() {
        if (this.state != State.ACTIVE && this.state != State.ROLLBACKONLY) {
            throw new TransactionException("rollback on transaction in state " + (Object)((Object)this.state));
        }
        Misc.fastDynamicLog(LOG, Level.FINEST, "rolling back %s", this);
        this.beforeCompletion();
        this.rollbackResources();
    }

    void rollbackResources() {
        if (this.resources != null) {
            for (StandardResource resource : this.resources) {
                try {
                    Misc.fastDynamicLog(LOG, Level.FINEST, "rolling back resource %s", resource);
                    resource.rollback();
                }
                catch (RuntimeException e) {
                    Misc.fastDynamicLog(LOG, Level.SEVERE, "rollback failed for resource %s: %s %s", resource, e, Misc.getStackTraceFrom(e));
                }
            }
        }
        this.state = State.ROLLEDBACK;
        this.afterCompletion();
        Misc.fastDynamicLog(LOG, Level.FINEST, "rolled back", new Object[0]);
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) {
        this.synchronizations.add(new StandardSynchronization(synchronization));
    }

    public void afterCompletion() {
        if (this.synchronizations != null) {
            for (StandardSynchronization synchronization : this.synchronizations) {
                synchronization.afterCompletion(this.state);
            }
        }
    }

    public void beforeCompletion() {
        if (this.synchronizations != null) {
            for (StandardSynchronization synchronization : this.synchronizations) {
                synchronization.beforeCompletion();
            }
        }
    }

    public void enlistResource(StandardResource standardResource) {
        Misc.fastDynamicLog(LOG, Level.FINEST, "enlisting resource %s to standard transaction", standardResource);
        this.resources.add(0, standardResource);
    }

    List<StandardResource> getResources() {
        return this.resources;
    }

    public String toString() {
        return "StandardTransaction[" + System.identityHashCode(this) + ", state=" + (Object)((Object)this.state) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CREATED,
        ACTIVE,
        ROLLBACKONLY,
        COMMITTED,
        ROLLEDBACK;

    }
}

