/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.tx;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.persistence.tx.StandardTransaction;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.Interceptor;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTransactionInterceptor
extends Interceptor {
    private static final Logger LOG = Logger.getLogger(StandardTransactionInterceptor.class.getName());

    @Override
    public <T> T execute(Command<T> command) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            throw new OrchestraRuntimeException("no environment for managing hibernate transaction");
        }
        StandardTransaction standardTransaction = environment.get(StandardTransaction.class);
        if (standardTransaction == null) {
            throw new OrchestraRuntimeException("no standard-transaction in environment");
        }
        standardTransaction.begin();
        try {
            T t = this.next.execute(command);
            return t;
        }
        catch (RuntimeException e) {
            Misc.fastDynamicLog(LOG, Level.SEVERE, "Failed executing command %s: %s %s", command, e, Misc.getStackTraceFrom(e));
            standardTransaction.setRollbackOnly();
            throw e;
        }
        finally {
            standardTransaction.complete();
        }
    }
}

