/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.CompositeElement;
import org.ow2.orchestra.definition.ExceptionHandler;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.activity.BaseCatchActivity;
import org.ow2.orchestra.definition.activity.CatchActivity;
import org.ow2.orchestra.definition.activity.CompensationHandlerActivity;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.persistence.db.TimerSession;
import org.ow2.orchestra.runtime.BpelInstance;
import org.ow2.orchestra.runtime.CorrelationSetRuntime;
import org.ow2.orchestra.runtime.ExecutionState;
import org.ow2.orchestra.runtime.FlowRuntime;
import org.ow2.orchestra.runtime.ForEachRuntime;
import org.ow2.orchestra.runtime.PartnerLinkRuntime;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.runtime.WaitingExecution;
import org.ow2.orchestra.runtime.op.AtomicOperation;
import org.ow2.orchestra.runtime.op.ExecuteNode;
import org.ow2.orchestra.runtime.op.MoveToChildNode;
import org.ow2.orchestra.runtime.op.MoveToParentNode;
import org.ow2.orchestra.runtime.op.Signal;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReplierKey;
import org.ow2.orchestra.services.itf.Replier;
import org.ow2.orchestra.services.job.Job;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.job.TimerImpl;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelExecution {
    public static final String ADDITIONNAL_SCOPE_VARIABLES = "additionnalScopeVariables";
    public static final String SCOPE_STATE_VARIABLE = "scopeState";
    public static final AtomicOperation EXECUTE_NODE = new ExecuteNode();
    public static final AtomicOperation PROPAGATE_TO_PARENT = new MoveToParentNode();
    private static final Logger LOG = Logger.getLogger(BpelExecution.class.getName());
    private static final long serialVersionUID = 1L;
    protected long dbid;
    protected int dbversion;
    protected String id;
    protected ExecutionState state;
    protected Node currentNode;
    protected String currentNodeName;
    protected Collection<BpelExecution> executions;
    protected BpelExecution parent = null;
    protected BpelInstance processInstance;
    protected Map<String, Object> variables = new HashMap<String, Object>();
    protected List<JobImpl<?>> jobs = new ArrayList();
    protected Queue<AtomicOperation> atomicOperations;
    protected boolean waitForSignal;
    protected Node previousNode;
    protected Exception exception;
    protected ActivityInstanceUUID activityInstanceUUID;
    protected FlowRuntime flowRuntime;
    protected ForEachRuntime forEachRuntime;
    protected ScopeRuntime scopeRuntime;
    protected WaitingExecution waitingExecution;
    protected ExecutionState resumeState;

    public FlowRuntime getFlowRuntimeWithLink(String linkName) {
        FlowRuntime fr = this.getFlowRuntime();
        if (fr != null && fr.hasLink(linkName)) {
            return fr;
        }
        if (this.getParent() != null) {
            return this.getParent().getFlowRuntimeWithLink(linkName);
        }
        return null;
    }

    public ScopeRuntime getCurrentScopeRuntime() {
        if (this.scopeRuntime != null) {
            return this.scopeRuntime;
        }
        if (this.parent != null) {
            return this.getParent().getCurrentScopeRuntime();
        }
        return null;
    }

    public ScopeRuntime getScopeRuntimeWithVariable(String variableName) {
        if (this.scopeRuntime != null && this.scopeRuntime.containsVariable(variableName)) {
            return this.scopeRuntime;
        }
        if (this.parent != null) {
            return this.getParent().getScopeRuntimeWithVariable(variableName);
        }
        return null;
    }

    public ScopeRuntime getScopeRuntimeWithCS(String csName) {
        Scope scope;
        if (this.scopeRuntime != null && (scope = (Scope)this.getProcessDefinition().getNode(this.scopeRuntime.getScopeNodeUUID()).getBehaviour()).getCorrelationSets().containsKey(csName)) {
            return this.scopeRuntime;
        }
        if (this.parent != null) {
            return this.getParent().getScopeRuntimeWithCS(csName);
        }
        return null;
    }

    public ScopeRuntime getScopeRuntimeWithPLNK(String partnerLinkName) {
        Scope scope;
        if (this.scopeRuntime != null && (scope = (Scope)this.getProcessDefinition().getNode(this.scopeRuntime.getScopeNodeUUID()).getBehaviour()).getPartnerLinks().containsKey(partnerLinkName)) {
            return this.scopeRuntime;
        }
        if (this.parent != null) {
            return this.getParent().getScopeRuntimeWithPLNK(partnerLinkName);
        }
        return null;
    }

    public ScopeRuntime getScopeRuntimeWithScope(Scope scope) {
        if (this.scopeRuntime != null && this.scopeRuntime.getScopeNodeUUID().equals(scope.getUUID().toString())) {
            return this.scopeRuntime;
        }
        if (this.parent != null) {
            return this.getParent().getScopeRuntimeWithScope(scope);
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BpelExecution");
        if (this.getNode() != null) {
            AbstractActivity activity = this.getNode().getBehaviour();
            sb.append('[');
            sb.append(activity.getName());
            sb.append(']');
        }
        sb.append(this.hashCode());
        return sb.toString();
    }

    public BpelProcess getProcessDefinition() {
        return this.getProcessInstance().getProcessDefinition();
    }

    public PartnerLinkRuntime getPartnerLinkRuntime(String partnerLinkName) {
        ScopeRuntime scopeRuntimeWithPLNK = this.getScopeRuntimeWithPLNK(partnerLinkName);
        if (scopeRuntimeWithPLNK != null) {
            return scopeRuntimeWithPLNK.getPartnerLink(partnerLinkName);
        }
        return null;
    }

    public Object getVariableValue(String variableName) {
        VariableRuntime variable = this.getVariableByName(variableName);
        return variable.getValue();
    }

    public VariableRuntime getVariableByName(String variableName) {
        Misc.fastDynamicLog(LOG, Level.FINE, "Getting variable %s", variableName);
        ScopeRuntime currentRuntimeScope = this.getScopeRuntimeWithVariable(variableName);
        if (currentRuntimeScope != null) {
            return currentRuntimeScope.getVariable(variableName);
        }
        return null;
    }

    public Variable getVariableDefinition(String variableName) {
        Misc.fastDynamicLog(LOG, Level.FINE, "Getting variable definition %s", variableName);
        AbstractActivity activity = this.getNode().getBehaviour();
        switch (activity.getType()) {
            case SCOPE: {
                Variable var = ((Scope)activity).getVariable(variableName);
                if (var == null) break;
                return var;
            }
            case CATCH_HANDLER: {
                Variable var2 = ((CatchActivity)activity).getVariable(variableName);
                if (var2 == null) break;
                return var2;
            }
        }
        if (this.scopeRuntime != null && this.scopeRuntime.containsVariable(variableName)) {
            Scope scope = (Scope)this.getProcessDefinition().getNode(this.scopeRuntime.getScopeNodeUUID()).getBehaviour();
            return scope.getVariable(variableName);
        }
        if (this.getParent() != null) {
            return this.getParent().getVariableDefinition(variableName);
        }
        return null;
    }

    public CorrelationSetRuntime getCorrelationSetByName(String csName) {
        Misc.fastDynamicLog(LOG, Level.FINE, "Getting CorrelationSet %s", csName);
        ScopeRuntime scopeRuntimeWithCS = this.getScopeRuntimeWithCS(csName);
        if (scopeRuntimeWithCS != null) {
            return scopeRuntimeWithCS.getCorrelationSet(csName);
        }
        return null;
    }

    public void pushFlowRuntime(FlowRuntime flowRuntimeToPush) {
        if (this.flowRuntime == null) {
            this.flowRuntime = flowRuntimeToPush;
        } else {
            Misc.unreachableStatement("One execution should have only one flowRuntime runtime");
        }
    }

    public FlowRuntime getFlowRuntime() {
        return this.flowRuntime;
    }

    public void pushForEachRuntime(ForEachRuntime forEachRuntimeToPush) {
        if (this.forEachRuntime != null) {
            Misc.unreachableStatement("One execution should have only one foreach runtime");
        }
        this.forEachRuntime = forEachRuntimeToPush;
    }

    public ForEachRuntime getForEachRuntime() {
        return this.forEachRuntime;
    }

    public void pushScopeRuntime(ScopeRuntime scopeRuntimeToPush) {
        if (this.scopeRuntime != null) {
            Misc.unreachableStatement("One execution should have only one scopeRuntime");
        }
        this.scopeRuntime = scopeRuntimeToPush;
        EnvTool.getRepository().storeScopeRuntime(scopeRuntimeToPush);
    }

    public ScopeRuntime popScopeRuntime(boolean shouldAdd) {
        if (this.scopeRuntime == null) {
            Misc.unreachableStatement("There is no scopeRuntime to pop!");
        }
        ScopeRuntime res = this.scopeRuntime;
        this.scopeRuntime = null;
        ScopeRuntime parentScopeRuntime = this.getCurrentScopeRuntime();
        Node chNode = this.getNode().getNodes().get(3);
        CompensationHandlerActivity chActivity = (CompensationHandlerActivity)chNode.getBehaviour();
        if (!(!shouldAdd || chActivity.isDefaultCH() && res.getEndedChildren().isEmpty())) {
            if (parentScopeRuntime == null) {
                Misc.unreachableStatement("parent is null");
                return null;
            }
            parentScopeRuntime.addEndedChild(res);
        } else {
            if (parentScopeRuntime != null) {
                parentScopeRuntime.getEndedChildren().remove(res);
            }
            EnvTool.getRepository().removeScopeRuntime(res);
        }
        return res;
    }

    public ScopeRuntime getScopeRuntime() {
        return this.scopeRuntime;
    }

    public Replier getReplier(OperationKey operationKey, String messageExchange) {
        if (this.scopeRuntime != null) {
            ReplierKey replierKey = new ReplierKey(operationKey, messageExchange, this.scopeRuntime);
            Iterator<Replier> replierIterator = this.getProcessInstance().getRepliers().iterator();
            while (replierIterator.hasNext()) {
                Replier replier = replierIterator.next();
                if (!replier.getReplierKey().equals(replierKey)) continue;
                replierIterator.remove();
                return replier;
            }
        }
        if (this.parent != null) {
            return this.getParent().getReplier(operationKey, messageExchange);
        }
        return null;
    }

    public void setWaitingExecution(WaitingExecution waitingExecution) {
        this.waitingExecution = waitingExecution;
        EnvTool.getRepository().storeWaitingExecution(waitingExecution);
    }

    public void resetWaitingExecution() {
        if (this.getWaitingExecution() != null) {
            EnvTool.getRepository().removeWaitingExecution(this.getWaitingExecution());
        }
        this.waitingExecution = null;
    }

    public WaitingExecution getWaitingExecution() {
        return this.waitingExecution;
    }

    public boolean hasWaitingExecution() {
        return this.waitingExecution != null && this.waitingExecution.getInboundMessageElementName() != null && !"".equals(this.waitingExecution.getInboundMessageElementName());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BpelExecution)) {
            return obj.equals(this);
        }
        BpelExecution other = (BpelExecution)obj;
        return other.getId().equals(this.id);
    }

    public Set<BpelExecution> searchWaitingExecutions() {
        HashSet<BpelExecution> res = new HashSet<BpelExecution>();
        if (this.hasWaitingExecution()) {
            res.add(this);
        }
        if (this.getExecutions() != null) {
            for (BpelExecution child : this.getExecutions()) {
                res.addAll(child.searchWaitingExecutions());
            }
        }
        return res;
    }

    public void terminate() {
        ActivityType activityType = this.getNode().getBehaviour().getType();
        Misc.fastDynamicLog(LOG, Level.FINEST, "Terminating BpelExecution %s, activity type %s, node name %s", new Object[]{this, activityType, this.getNode().getName()});
        if (this.scopeRuntime != null) {
            if (!ActivityType.SCOPE.equals((Object)activityType)) {
                Misc.unreachableStatement("The execution " + this + " has a scopeRuntime but is not a " + (Object)((Object)ActivityType.SCOPE) + " (it is a " + (Object)((Object)activityType) + ")");
            } else {
                Misc.fastDynamicLog(LOG, Level.FINEST, "Scope state for BpelExecution %s is %s", new Object[]{this, this.scopeRuntime.getState()});
            }
        } else if (ActivityType.SCOPE.equals((Object)activityType)) {
            Misc.unreachableStatement("The execution " + this + " doen't have any scopeRuntime but is a " + (Object)((Object)activityType));
        }
        Collection<BpelExecution> childExecutions = this.getExecutions();
        if (childExecutions != null && !childExecutions.isEmpty()) {
            BpelExecution childBpelExecution = childExecutions.iterator().next();
            Misc.fastDynamicLog(LOG, Level.FINEST, "Terminating child %s out of %s children", childBpelExecution, childExecutions.size());
            childBpelExecution.terminate();
            return;
        }
        if (ActivityType.SCOPE.equals((Object)activityType) && ScopeState.HANDLING_FAULT.equals((Object)this.scopeRuntime.getState())) {
            this.executeFaultHandler();
            return;
        }
        if (ActivityType.SCOPE.equals((Object)activityType) && (ScopeState.RUNNING.equals((Object)this.scopeRuntime.getState()) || ScopeState.RETHROWING_FAULT.equals((Object)this.scopeRuntime.getState()))) {
            this.executeTerminationHandler();
            return;
        }
        if (ActivityType.FOR_EACH.equals((Object)activityType) && this.getForEachRuntime() != null && this.getForEachRuntime().isCompleted()) {
            this.signal("all-finished");
            return;
        }
        if (ActivityType.COMPENSATION_HANDLER.equals((Object)activityType) && this.getParent().getScopeRuntime() != null) {
            this.signalCompensationHandler();
        } else if (ActivityType.SCOPE_EVENT_HANDLER.equals((Object)activityType)) {
            this.terminateEventHandler();
        } else {
            this.terminateCurrentActivity();
        }
    }

    private void terminateEventHandler() {
        this.removeExecution();
        if (this.getState().equals((Object)ExecutionState.async)) {
            this.unlock();
            this.end(ExecutionState.ended);
        } else {
            this.end(ExecutionState.cancelled);
        }
        if (this.parent != null) {
            Misc.fastDynamicLog(LOG, Level.FINEST, "Terminating parent %s", this.parent);
            this.parent.terminate();
        }
    }

    private void terminateCurrentActivity() {
        this.removeExecution();
        if (this.getState().equals((Object)ExecutionState.async)) {
            this.unlock();
            this.end(ExecutionState.ended);
        } else {
            this.end(ExecutionState.cancelled);
            if (this.parent != null && this.parent.getNode() != this.getNode()) {
                AbstractActivity activity = this.getNode().getBehaviour();
                EnvTool.getRecorder().recordActivityTerminated(activity.createRuntimeData(this));
            }
        }
        if (this.parent != null) {
            Misc.fastDynamicLog(LOG, Level.FINEST, "Terminating parent %s", this.parent);
            this.parent.terminate();
        }
    }

    private void signalCompensationHandler() {
        if (this.getParent().getScopeRuntime().getLastException() != null) {
            BpelExecution chExecution = this.getParent();
            chExecution.removeExecution(this);
            chExecution.end(ExecutionState.ended);
            ScopeRuntime chScopeRuntime = chExecution.popScopeRuntime(false);
            chScopeRuntime.setState(ScopeState.COMPENSATED, this);
            BpelExecution compensateExecution = chScopeRuntime.getCompensateExecution();
            chScopeRuntime.setCompensateExecution(null);
            BpelExecution parentExecution = chExecution.getParent();
            parentExecution.removeExecution(chExecution);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("exception", chScopeRuntime.getLastException());
            compensateExecution.signal(params);
        }
    }

    private void executeTerminationHandler() {
        this.scopeRuntime.setState(ScopeState.TERMINATING, this);
        List<Node> nodes = this.getNode().getNodes();
        if (nodes == null) {
            Misc.unreachableStatement("The scope node " + this.getNode() + " doesn't have any children");
            return;
        }
        if (nodes.size() < 5) {
            Misc.unreachableStatement("The scope node " + this.getNode() + " has only " + nodes.size() + " children, it should have had at least " + 5);
        }
        Node terminationHandler = nodes.get(2);
        BpelExecution terminationHandlerExecution = this.createExecution();
        Misc.fastDynamicLog(LOG, Level.FINEST, "Will execute the termination handler %s in BpelExecution %s for the BpelExecution %s", terminationHandler, terminationHandlerExecution, this);
        terminationHandlerExecution.execute(terminationHandler);
    }

    private void executeFaultHandler() {
        Node faultHandler;
        List<Node> nodes = this.getNode().getNodes();
        if (nodes == null) {
            Misc.unreachableStatement("The parent scope node doesn't have any children");
            return;
        }
        if (nodes.size() < 5) {
            Misc.unreachableStatement("The parent scope node has only " + nodes.size() + " children, it should have had at least " + 5);
        }
        if ((faultHandler = BaseCatchActivity.findFaultHandler(this.scopeRuntime, nodes, this.scopeRuntime.getLastException())) == null) {
            faultHandler = nodes.get(4);
        }
        Misc.fastDynamicLog(LOG, Level.FINEST, "Will execute the fault handler %s in BpelExecution %s", faultHandler, this);
        this.createExecution().execute(faultHandler);
    }

    public void exit() {
        if (this.isSuspended()) {
            this.setState(this.resumeState);
        }
        this.removeExecution();
        Collection<BpelExecution> childExecutions = this.getExecutions();
        if (childExecutions != null) {
            for (BpelExecution childExecution : new ArrayList<BpelExecution>(childExecutions)) {
                childExecution.exit();
            }
        }
        if (this.getState().equals((Object)ExecutionState.async)) {
            this.unlock();
            this.end(ExecutionState.ended);
        } else if (!this.isFinished()) {
            this.end(ExecutionState.cancelled);
            if (this.getParent() != null && this.getParent().getNode() != this.getNode()) {
                AbstractActivity activity = this.getNode().getBehaviour();
                EnvTool.getRecorder().recordActivityExited(activity.createRuntimeData(this));
            }
        }
    }

    protected void removeExecution() {
        this.resetWaitingExecution();
        this.removeJobs();
        if (this.parent != null) {
            this.waitForSignal();
            this.parent.removeExecution(this);
        }
    }

    public ActivityInstanceUUID getActivityInstanceUUID() {
        return this.activityInstanceUUID;
    }

    public ActivityInstanceUUID getEncloserActivityInstanceUUID() {
        return this.getEncloserActivityInstanceUUID(this.getActivityInstanceUUID());
    }

    private ActivityInstanceUUID getEncloserActivityInstanceUUID(ActivityInstanceUUID enclosedActivityUUID) {
        BpelExecution parentBpelExecution = this.getParent();
        if (enclosedActivityUUID.equals(this.getActivityInstanceUUID())) {
            if (parentBpelExecution == null) {
                return null;
            }
            return parentBpelExecution.getEncloserActivityInstanceUUID(enclosedActivityUUID);
        }
        return this.getActivityInstanceUUID();
    }

    public void setActivityInstanceUUID(ActivityInstanceUUID activityInstanceUUID) {
        this.activityInstanceUUID = activityInstanceUUID;
    }

    public void removeJobs() {
        JobDbSession jobSession = Environment.getFromCurrent(JobDbSession.class);
        for (Job job : new HashSet(this.getJobs())) {
            jobSession.delete(job);
        }
    }

    public ExecutionState getResumeState() {
        return this.resumeState;
    }

    public void setResumeState(ExecutionState resumeState) {
        this.resumeState = resumeState;
    }

    public void end() {
        this.end(ExecutionState.ended);
    }

    public void end(ExecutionState endState) {
        if (endState == null) {
            throw new OrchestraRuntimeException("state is null");
        }
        if (endState.equals((Object)ExecutionState.active) || endState.equals((Object)ExecutionState.created) || endState.equals((Object)ExecutionState.inactive) || endState.equals((Object)ExecutionState.suspended) || endState.equals((Object)ExecutionState.async)) {
            throw new OrchestraRuntimeException("invalid end state: " + (Object)((Object)endState));
        }
        if (endState.equals((Object)ExecutionState.ended)) {
            Misc.fastDynamicLog(LOG, Level.FINEST, "%s ends", this);
        } else {
            Misc.fastDynamicLog(LOG, Level.FINEST, "%s ends with state %s", new Object[]{this, endState});
        }
        if (this.executions != null) {
            for (BpelExecution child : this.executions) {
                child.end(endState);
            }
        }
        this.lock(endState);
        this.waitForSignal = true;
    }

    public void signal() {
        this.signal(null, null);
    }

    public void signal(String signal) {
        this.signal(signal, null);
    }

    public void signal(Map<String, Object> parameters) {
        this.signal(null, parameters);
    }

    public void signal(String signal, Map<String, Object> parameters) {
        this.checkLock();
        if (this.getNode() == null) {
            throw new OrchestraRuntimeException("execution is not in a node");
        }
        this.performAtomicOperation(new Signal(signal, parameters, this.getNode()));
    }

    public void execute(Node nodeToExecute) {
        if (nodeToExecute == null) {
            throw new OrchestraRuntimeException("node is null");
        }
        this.checkLock();
        this.waitForSignal = true;
        this.performAtomicOperation(new MoveToChildNode(nodeToExecute));
    }

    public void waitForSignal() {
        this.waitForSignal = true;
    }

    public void proceed() {
        this.checkLock();
        Node parentNode = this.getNode().getParentNode();
        if (parentNode != null) {
            this.performAtomicOperation(PROPAGATE_TO_PARENT);
        } else {
            this.end();
        }
    }

    public void move(Node destination, BpelExecution execution) {
        execution.move(destination);
    }

    public void move(Node destination) {
        this.checkLock();
        this.setNode(destination);
    }

    public void moveTo(Node destination) {
        this.setPreviousNode(this.getNode());
        this.setNode(destination);
    }

    public void createVariable(String variableKey, Object variableValue) {
        if (this.isFinished()) {
            throw new OrchestraRuntimeException("can't create variable '" + variableKey + "' on " + this + ": " + (Object)((Object)this.state));
        }
        Misc.fastDynamicLog(LOG, Level.FINEST, "create variable '%s' in '%s' with value '%s'", variableKey, this, variableValue);
        this.variables.put(variableKey, variableValue);
    }

    public Object getVariable(String variableKey) {
        return this.variables.get(variableKey);
    }

    public boolean removeVariable(String variableKey) {
        if (this.isFinished()) {
            throw new OrchestraRuntimeException("can't remove variable '" + variableKey + "' on " + this + ": " + (Object)((Object)this.state));
        }
        return this.variables.remove(variableKey) != null;
    }

    public void createTimer(String signalName, Date dueDate, Long repeat) {
        Environment environment;
        if (signalName == null) {
            throw new OrchestraRuntimeException("no signal specified");
        }
        Misc.fastDynamicLog(LOG, Level.FINEST, "creating timer on %s", this);
        TimerImpl timerImpl = this.instantiateTimer();
        timerImpl.setPriority(-2);
        timerImpl.setExecution(this);
        this.jobs.add(timerImpl);
        timerImpl.setSignalName(signalName);
        if (dueDate != null) {
            timerImpl.setDueDate(dueDate);
        }
        if (repeat != null) {
            timerImpl.setRepeat(repeat);
        }
        if ((environment = Environment.getCurrent()) == null) {
            throw new OrchestraRuntimeException("non environment for initializing timers");
        }
        TimerSession timerSession = environment.get(TimerSession.class);
        if (timerSession == null) {
            throw new OrchestraRuntimeException("no TimerSession in environment for initializing timers");
        }
        timerSession.schedule(timerImpl);
    }

    public List<JobImpl<?>> getJobs() {
        return this.jobs;
    }

    protected TimerImpl instantiateTimer() {
        return new TimerImpl();
    }

    public ExecutionState getState() {
        return this.state;
    }

    public void lock(ExecutionState lockState) {
        if (lockState == null) {
            throw new OrchestraRuntimeException("given state is null");
        }
        this.checkLock();
        Misc.fastDynamicLog(LOG, Level.FINEST, "locking %s", this);
        this.state = lockState;
    }

    public void unlock() {
        if (ExecutionState.active.equals((Object)this.state)) {
            throw new OrchestraRuntimeException("state is already active");
        }
        Misc.fastDynamicLog(LOG, Level.FINEST, "unlocking %s", this);
        this.state = ExecutionState.active;
    }

    public boolean isActive() {
        return ExecutionState.active.equals((Object)this.state);
    }

    public boolean isLocked() {
        return !this.isActive();
    }

    public boolean isSuspended() {
        return ExecutionState.suspended.equals((Object)this.state);
    }

    public boolean isEnded() {
        return ExecutionState.ended.equals((Object)this.state);
    }

    public boolean isFinished() {
        return ExecutionState.ended.equals((Object)this.state) || ExecutionState.cancelled.equals((Object)this.state);
    }

    protected void checkLock() {
        if (!ExecutionState.active.equals((Object)this.state)) {
            throw new OrchestraRuntimeException(this.toString() + " is not active: " + (Object)((Object)this.state));
        }
    }

    public void performAtomicOperation(AtomicOperation operation) {
        if (this.atomicOperations == null) {
            this.atomicOperations = new LinkedList<AtomicOperation>();
            this.atomicOperations.add(operation);
            try {
                while (!this.atomicOperations.isEmpty()) {
                    AtomicOperation atomicOperation = this.atomicOperations.remove();
                    atomicOperation.perform(this);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            finally {
                this.atomicOperations = null;
            }
        } else {
            this.atomicOperations.add(operation);
        }
    }

    public void handleException(CompositeElement observableElement, Exception thrownException, String rethrowMessage) {
        ArrayList<CompositeElement> processElements = new ArrayList<CompositeElement>();
        while (observableElement != null) {
            processElements.add(observableElement);
            observableElement = observableElement.getParent();
        }
        for (CompositeElement processElement : processElements) {
            ExceptionHandler exceptionHandler = processElement.getExceptionHandler();
            if (exceptionHandler == null || !exceptionHandler.matches(thrownException)) continue;
            try {
                exceptionHandler.handle(this, thrownException, processElement);
                return;
            }
            catch (Exception rethrowException) {
                if (exceptionHandler.isRethrowMasked()) continue;
                thrownException = rethrowException;
            }
        }
        Misc.fastDynamicLog(LOG, Level.FINEST, "rethrowing exception cause no exception handler for %s", thrownException);
        ExceptionHandler.rethrow(thrownException, rethrowMessage + ": " + thrownException.getMessage());
    }

    public BpelExecution createExecution() {
        if (this.isActive()) {
            this.lock(ExecutionState.inactive);
            this.waitForSignal = true;
        }
        BpelExecution childExecution = new BpelExecution();
        childExecution.id = UUID.randomUUID().toString();
        childExecution.processInstance = this.processInstance;
        childExecution.setNode(this.getNode());
        childExecution.state = ExecutionState.active;
        Misc.fastDynamicLog(LOG, Level.FINEST, "creating %s", childExecution);
        this.addExecution(childExecution);
        childExecution.setActivityInstanceUUID(this.activityInstanceUUID);
        EnvTool.getRepository().storeExecution(childExecution);
        return childExecution;
    }

    public void addExecution(BpelExecution execution) {
        BpelExecution executionImpl = execution;
        executionImpl.parent = this;
        if (this.executions == null) {
            this.executions = new ArrayList<BpelExecution>();
        }
        this.executions.add(executionImpl);
    }

    public void removeExecution(BpelExecution child) {
        if (this.executions != null) {
            if (this.executions.remove(child)) {
                if (this.state.equals((Object)ExecutionState.inactive) && this.executions.isEmpty()) {
                    Misc.fastDynamicLog(LOG, Level.FINEST, "last child execution was removed; unlocking", new Object[0]);
                    this.state = ExecutionState.active;
                } else {
                    Misc.fastDynamicLog(LOG, Level.FINEST, "removed %s from %s", child, this);
                }
            } else {
                throw new OrchestraRuntimeException(child + " is not a child execution of " + this);
            }
        }
        child.resetWaitingExecution();
        child.removeJobs();
        EnvTool.getRepository().removeExecution(child);
    }

    public String getNodeName() {
        return this.currentNodeName;
    }

    public Collection<BpelExecution> getExecutions() {
        return this.executions;
    }

    public BpelExecution getParent() {
        return this.parent;
    }

    public Node getPreviousNode() {
        return this.previousNode;
    }

    public BpelInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(BpelInstance processInstance) {
        this.processInstance = processInstance;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isWaitForSignal() {
        return this.waitForSignal;
    }

    public void setWaitForSignal(boolean waitForSignal) {
        this.waitForSignal = waitForSignal;
    }

    public void setState(ExecutionState state) {
        this.state = state;
    }

    public void setExecutions(Collection<BpelExecution> executions) {
        this.executions = executions;
    }

    public void setParent(BpelExecution parent) {
        this.parent = parent;
    }

    public void setPreviousNode(Node previousNode) {
        this.previousNode = previousNode;
    }

    public Node getNode() {
        if (this.currentNode == null) {
            BpelProcess processDef = this.getProcessDefinition();
            this.currentNode = processDef.getNode(this.getCurrentNodeName());
            if (this.currentNode == null) {
                System.out.println("No node found for " + this.currentNodeName + ". Known nodes:" + processDef.getNodesMap().keySet());
            }
        }
        return this.currentNode;
    }

    public void setNode(Node node) {
        this.currentNode = node;
        this.currentNodeName = node.getName();
    }

    public long getDbid() {
        return this.dbid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCurrentNodeName() {
        return this.currentNodeName;
    }
}

