/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.db.MessageSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ExecutionState;
import org.ow2.orchestra.services.itf.ProcessRepository;
import org.ow2.orchestra.services.itf.Replier;
import org.ow2.orchestra.services.job.CheckHasMessageJob;
import org.ow2.orchestra.services.job.Job;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.services.job.Timer;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelInstance
extends BpelExecution {
    private static final Logger LOG = Logger.getLogger(BpelExecution.class.getName());
    protected ProcessInstanceUUID processInstanceUUID;
    protected Date parentInstanceStartTime;
    protected ActivityState instanceState = null;
    protected Set<Replier> repliers = new HashSet<Replier>();
    protected ProcessDefinitionUUID processUUID;
    protected transient BpelProcess bpelProcess;

    public Set<Replier> getRepliers() {
        return this.repliers;
    }

    public void addReplier(Replier replier) {
        this.getRepliers().add(replier);
    }

    public ProcessInstanceUUID getProcessInstanceUUID() {
        return this.processInstanceUUID;
    }

    public void setProcessInstanceUUID(ProcessInstanceUUID processInstanceUUID) {
        this.processInstanceUUID = processInstanceUUID;
    }

    public ProcessInstanceData getProcessInstanceData() {
        return new ProcessInstanceData(this.getProcessDefinition().getProcessDefinitionData(), this.getProcessInstanceUUID(), this.getProcessInstanceState());
    }

    public boolean isInstanceSuspended() {
        return ActivityState.SUSPENDED.equals((Object)this.getProcessInstanceState());
    }

    public void suspendInstance() {
        if (ActivityState.RUNNING.equals((Object)this.getProcessInstanceState())) {
            BpelInstance.suspend(this);
            this.setProcessInstanceState(ActivityState.SUSPENDED);
            EnvTool.getRecorder().recordInstanceUpdated(this.getProcessInstanceData());
        }
    }

    public void resumeInstance() {
        if (ActivityState.SUSPENDED.equals((Object)this.getProcessInstanceState())) {
            BpelInstance.resume(this);
            this.setProcessInstanceState(ActivityState.RUNNING);
            EnvTool.getRecorder().recordInstanceUpdated(this.getProcessInstanceData());
        }
    }

    public ActivityState getProcessInstanceState() {
        return this.instanceState;
    }

    public void setProcessInstanceState(ActivityState state) {
        this.instanceState = state;
    }

    @Override
    protected void removeExecution() {
        super.removeExecution();
        this.setProcessInstanceState(ActivityState.EXITED);
    }

    @Override
    public BpelProcess getProcessDefinition() {
        if (this.bpelProcess == null) {
            this.bpelProcess = Environment.getFromCurrent(ProcessRepository.class).getProcess(this.processUUID);
        }
        return this.bpelProcess;
    }

    public void initializeProcessInstance(BpelProcess executionProcessDefinition) {
        this.processUUID = executionProcessDefinition.getUUID();
        this.setNode(executionProcessDefinition.getInitial());
        this.processInstance = this;
        this.state = ExecutionState.created;
        this.parentInstanceStartTime = new Date();
    }

    public void begin() {
        if (!ExecutionState.created.equals((Object)this.state)) {
            throw new OrchestraRuntimeException(this.toString() + " is already begun: " + (Object)((Object)this.state));
        }
        this.setNode(this.getProcessDefinition().getInitial());
        this.state = ExecutionState.active;
        if (this.getNode() != null) {
            this.performAtomicOperation(BpelExecution.EXECUTE_NODE);
        }
    }

    public void setParentInstanceStartTime(Date startTime) {
        this.parentInstanceStartTime = startTime;
    }

    public Date getParentInstanceStartTime() {
        return this.parentInstanceStartTime;
    }

    public ProcessDefinitionUUID getProcessDefinitionUUID() {
        return this.processUUID;
    }

    private static void resume(BpelExecution execution) {
        for (BpelExecution n : execution.getExecutions()) {
            BpelInstance.resume(n);
        }
        if (execution.isSuspended()) {
            if (execution.getResumeState() == null) {
                throw new OrchestraRuntimeException("unable to resume " + execution + ": resume state is not defined");
            }
            if (execution.getResumeState().equals((Object)ExecutionState.active)) {
                AbstractActivity activity = execution.getNode().getBehaviour();
                if (activity.getType().equals((Object)ActivityType.PICK)) {
                    boolean removeOnMessage = false;
                    Iterator<JobImpl<?>> nodeJobs = execution.getJobs().iterator();
                    while (nodeJobs.hasNext() && !removeOnMessage) {
                        Job j = nodeJobs.next();
                        if (j instanceof Timer) {
                            if (!j.getDueDate().before(new Date(System.currentTimeMillis()))) continue;
                            removeOnMessage = true;
                            continue;
                        }
                        if (!(j instanceof CheckHasMessageJob)) continue;
                        nodeJobs.remove();
                    }
                    if (removeOnMessage) {
                        execution.resetWaitingExecution();
                    } else {
                        Environment.getFromCurrent(MessageSession.class).send(new CheckHasMessageJob(execution));
                    }
                } else if (activity.isInboundMessageElement()) {
                    execution.removeJobs();
                    Environment.getFromCurrent(MessageSession.class).send(new CheckHasMessageJob(execution));
                }
            }
            execution.setState(execution.getResumeState());
            Iterator<Object> i$ = execution.getJobs().iterator();
            while (i$.hasNext()) {
                JobImpl j;
                JobImpl job = j = (JobImpl)i$.next();
                job.setSuspended(false);
                if (job.getLockOwner() == null) continue;
                job.setLockOwner(null);
                job.setLockExpirationTime(null);
            }
            Misc.fastDynamicLog(LOG, Level.FINE, "Execution %s now running.", execution);
        } else {
            Misc.fastDynamicLog(LOG, Level.FINE, "Execution %s is already running.", execution);
        }
    }

    private static void suspend(BpelExecution execution) {
        if (!execution.getExecutions().isEmpty()) {
            for (BpelExecution n : execution.getExecutions()) {
                BpelInstance.suspend(n);
            }
        }
        if (!execution.isSuspended()) {
            execution.setResumeState(execution.getState());
            execution.setState(ExecutionState.suspended);
            Iterator<Object> i$ = execution.getJobs().iterator();
            while (i$.hasNext()) {
                JobImpl j;
                JobImpl job = j = (JobImpl)i$.next();
                job.setSuspended(true);
                if (job.getLockOwner() == null) continue;
                job.setLockOwner(null);
                job.setLockExpirationTime(null);
            }
            Misc.fastDynamicLog(LOG, Level.FINE, "Execution %s suspended.", execution);
        } else {
            Misc.fastDynamicLog(LOG, Level.FINE, "Execution %s is already suspended.", execution);
        }
    }
}

