/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.facade.data.runtime.ActivityInstanceData;
import org.ow2.orchestra.facade.data.runtime.CorrelationSetInitializedData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.wsdl.PropertyAlias;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationSetRuntime {
    protected long dbid;
    protected int dbversion;
    protected static final Logger LOG = Logger.getLogger(CorrelationSetRuntime.class.getName());
    protected String name;
    protected Map<QName, Document> propertyValues;
    protected boolean initialized = false;
    protected ScopeRuntime scopeRuntime;

    protected CorrelationSetRuntime() {
    }

    public CorrelationSetRuntime(CorrelationSet correlationSetDefinition, ScopeRuntime scopeRuntime) {
        this.scopeRuntime = scopeRuntime;
        this.name = correlationSetDefinition.getName();
        this.propertyValues = new HashMap<QName, Document>();
    }

    public Node getPropertyValue(QName propertyName) {
        Document doc = this.propertyValues.get(propertyName);
        if (doc != null) {
            Element elt = doc.getDocumentElement();
            Element child = XmlUtil.element(elt);
            if (child != null) {
                return child;
            }
            return elt.getFirstChild();
        }
        return null;
    }

    public void setPropertyValue(QName propertyName, Node value) {
        Element el = XmlUtil.getDocumentWithOneElement(new QName("http://orchestra.ow2.org", "ORCHESTRA_anonymous_element"));
        el.appendChild(el.getOwnerDocument().importNode(value, true));
        this.propertyValues.put(propertyName, el.getOwnerDocument());
    }

    protected boolean validatePropertyValue(PropertyAlias propertyAlias, MessageVariable message) {
        try {
            Node expectedValue = this.getPropertyValue(propertyAlias.getPropertyName());
            Node value = propertyAlias.getPropertyValueFromMessage(message);
            if (value == null) {
                return expectedValue == null;
            }
            if (expectedValue == null) {
                return false;
            }
            boolean valid = XmlUtil.areNodeEquals(expectedValue, value);
            if (LOG.isLoggable(Level.FINEST)) {
                if (!valid) {
                    LOG.finest("Trying to validate CS value: expected " + XmlUtil.toString(expectedValue) + " got " + XmlUtil.toString(value));
                } else {
                    LOG.finest("CS value valid: " + XmlUtil.toString(expectedValue));
                }
            }
            return valid;
        }
        catch (Exception ex) {
            throw new OrchestraRuntimeException("In Correlation: Function call exception:" + ex, ex);
        }
    }

    public boolean validateCSValues(WsdlsInfos wsdlsInfos, MessageVariable message, QName messageType, Correlation correlation) {
        List<PropertyAlias> propertyAliases = correlation.getCorrelationSet().getPropertyAliasRefs(wsdlsInfos, messageType);
        for (PropertyAlias propertyAlias : propertyAliases) {
            if (this.validatePropertyValue(propertyAlias, message)) continue;
            return false;
        }
        return true;
    }

    public void checkCSValues(BpelExecution execution, MessageVariable message, QName messageType, Correlation correlation) {
        Correlation.Initiate initiate = correlation.getInitiate();
        if (Correlation.Initiate.yes.equals((Object)initiate) || !this.isInitialized()) {
            this.initiate(execution, message, messageType, correlation);
        } else if (!this.validateCSValues(execution.getProcessDefinition().getWsdlInfos(), message, messageType, correlation)) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.correlationViolation, "Correlation consistency constraint violated", null);
        }
    }

    public void initiate(BpelExecution execution, MessageVariable message, QName messageType, Correlation correlation) {
        Correlation.Initiate initiate = correlation.getInitiate();
        if (this.isInitialized()) {
            if (Correlation.Initiate.yes.equals((Object)initiate)) {
                throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.correlationViolation, "CorrelationSet already initialized and initiate='yes'", null);
            }
            return;
        }
        if (Correlation.Initiate.no.equals((Object)initiate)) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.correlationViolation, "CorrelationSet not initialized and initiate='no'", null);
        }
        List<PropertyAlias> propertyAliases = execution.getProcessDefinition().getWsdlInfos().getPropertyAliases(correlation.getCorrelationSet().getProperties().values(), messageType);
        for (PropertyAlias propertyAlias : propertyAliases) {
            try {
                Element partElement;
                Node value = partElement = message.getPartValue(propertyAlias.getPart());
                if (propertyAlias.getQuery() != null) {
                    value = propertyAlias.getQuery().getEvaluator().evaluate(partElement);
                }
                this.setPropertyValue(propertyAlias.getPropertyName(), value);
            }
            catch (Exception ex) {
                throw new OrchestraRuntimeException("In Correlation: Function call exception:" + ex, ex);
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Initialized correlation set with values: " + this.propertyValues);
        }
        AbstractActivity activity = execution.getNode().getBehaviour();
        this.setInitialized(true, activity.createRuntimeData(execution));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CorrelationSetRuntime)) {
            return false;
        }
        CorrelationSetRuntime corr = (CorrelationSetRuntime)obj;
        return this.name.equals(corr.getName()) && ((Object)this.propertyValues).equals(corr.getPropertyValues());
    }

    public int hashCode() {
        StringBuffer result = new StringBuffer();
        result.append("name=\"" + this.name + "\" properties=\"");
        for (QName property : this.propertyValues.keySet()) {
            result.append(property);
        }
        result.append("\"");
        return result.toString().hashCode();
    }

    public Map<QName, Document> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(Map<QName, Document> propertyValues) {
        this.propertyValues = propertyValues;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean isInitialized, ActivityInstanceData activityData) {
        this.initialized = isInitialized;
        EnvTool.getRecorder().recordCorrelationSetInitialized(new CorrelationSetInitializedData(this.scopeRuntime.getActivityInstanceUUID(), activityData, this.name, this.propertyValues));
    }
}

