/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import org.ow2.orchestra.facade.data.runtime.TransitionConditionUpdateData;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.EnvTool;

public class LinkRuntime {
    protected long dbid;
    protected int dbversion;
    protected LinkStatus status = LinkStatus.UNSET;
    protected String name;
    protected BpelExecution waitingExecution = null;
    protected ActivityInstanceUUID flowActivityInstanceUUID;

    protected LinkRuntime() {
    }

    public LinkRuntime(String name, ActivityInstanceUUID flowActivityInstanceUUID) {
        this.name = name;
        this.flowActivityInstanceUUID = flowActivityInstanceUUID;
    }

    public LinkStatus getStatus() {
        return this.status;
    }

    public void setStatus(LinkStatus status) {
        this.status = status;
        EnvTool.getRecorder().recordTransitionConditionUpdated(new TransitionConditionUpdateData(this.flowActivityInstanceUUID, status.getBooleanValue(), this.name));
    }

    public BpelExecution getWaitingExecution() {
        return this.waitingExecution;
    }

    public void setWaitingExecution(BpelExecution waitingExecution) {
        this.waitingExecution = waitingExecution;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinkStatus {
        TRUE(Boolean.TRUE),
        FALSE(Boolean.FALSE),
        UNSET(null);

        private Boolean booleanValue;

        private LinkStatus(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        public Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public static LinkStatus get(Boolean valueOf) {
            if (Boolean.TRUE == valueOf) {
                return TRUE;
            }
            if (Boolean.FALSE == valueOf) {
                return FALSE;
            }
            return UNSET;
        }
    }
}

