/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.facade.data.runtime.ActivityInstanceData;
import org.ow2.orchestra.facade.data.runtime.PartnerLinkUpdateData;
import org.ow2.orchestra.facade.runtime.PartnerLinkUpdateType;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PartnerLinkRuntime {
    protected long dbid;
    protected int dbversion;
    protected ScopeRuntime scopeRuntime;
    protected String name;
    protected Document partnerRoleEndPointReference;

    protected PartnerLinkRuntime() {
    }

    public PartnerLinkRuntime(PartnerLink partnerLinkDefinition, BpelExecution execution, ScopeRuntime scopeRuntime) {
        this.scopeRuntime = scopeRuntime;
        this.name = partnerLinkDefinition.getName();
        if (partnerLinkDefinition.getMyRolePortTypeQName() != null) {
            this.initializeMyRole(execution, partnerLinkDefinition);
        }
        if (partnerLinkDefinition.getPartnerRolePortTypeQName() != null) {
            this.initializePartnerRole(execution, partnerLinkDefinition);
        }
    }

    public void initializePartnerRole(BpelExecution execution, PartnerLink partnerLinkDefinition) {
        if (partnerLinkDefinition.getDefaultPartnerRoleEndPointReference() != null) {
            AbstractActivity activity = execution.getNode().getBehaviour();
            EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(execution.getActivityInstanceUUID(), activity.createRuntimeData(execution), partnerLinkDefinition.getName(), PartnerLinkUpdateType.PARTNER_ROLE_INITIALIZED, partnerLinkDefinition.getDefaultPartnerRoleEndPointReference().getDocumentElement()));
        }
    }

    public void initializeMyRole(BpelExecution execution, PartnerLink partnerLinkDefinition) {
        if (partnerLinkDefinition.getDefaultMyRoleEndPointReference() != null) {
            AbstractActivity activity = execution.getNode().getBehaviour();
            EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(execution.getActivityInstanceUUID(), activity.createRuntimeData(execution), partnerLinkDefinition.getName(), PartnerLinkUpdateType.MY_ROLE_INITIALIZED, partnerLinkDefinition.getDefaultMyRoleEndPointReference().getDocumentElement()));
        }
    }

    public Element getMyRoleEndPointReference(BpelExecution execution) {
        Document endpoint = this.getPartnerLinkDefinition(execution).getDefaultMyRoleEndPointReference();
        if (endpoint != null) {
            return endpoint.getDocumentElement();
        }
        return null;
    }

    public Element getPartnerRoleEndPointReference(BpelExecution execution) {
        if (this.partnerRoleEndPointReference != null) {
            return this.partnerRoleEndPointReference.getDocumentElement();
        }
        Document endpoint = this.getPartnerLinkDefinition(execution).getDefaultPartnerRoleEndPointReference();
        if (endpoint != null) {
            return endpoint.getDocumentElement();
        }
        return null;
    }

    public void setPartnerRoleEndPointReference(Element partnerRoleEPR, ActivityInstanceData activityInstanceData) {
        Document doc = XmlUtil.getNewDocument();
        doc.appendChild(doc.importNode(partnerRoleEPR, true));
        this.partnerRoleEndPointReference = doc;
        EnvTool.getRecorder().recordPartnerLinkUpdated(new PartnerLinkUpdateData(this.scopeRuntime.getActivityInstanceUUID(), activityInstanceData, this.getName(), PartnerLinkUpdateType.PARTNER_ROLE_UPDATED, this.partnerRoleEndPointReference.getDocumentElement()));
    }

    public String getName() {
        return this.name;
    }

    public PartnerLink getPartnerLinkDefinition(BpelExecution execution) {
        Scope scope = (Scope)execution.getProcessDefinition().getNode(this.scopeRuntime.getScopeNodeUUID()).getBehaviour();
        return scope.getPartnerLinks().get(this.name);
    }

    public long getDbid() {
        return this.dbid;
    }
}

