/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.data.runtime.ScopeStateUpdateData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.CorrelationSetRuntime;
import org.ow2.orchestra.runtime.PartnerLinkRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeRuntime {
    protected long dbid;
    protected int dbversion;
    protected String scopeNodeUUID = null;
    protected List<ScopeRuntime> endedChildren = new ArrayList<ScopeRuntime>();
    protected ScopeRuntime parent;
    protected long endedTime;
    protected Map<String, VariableRuntime> variables = null;
    protected Map<String, PartnerLinkRuntime> partnerLinks = null;
    protected Map<String, CorrelationSetRuntime> correlationSets = null;
    protected ActivityInstanceUUID activityInstanceUUID;
    protected ScopeState state = ScopeState.INITIALIZATION_ERROR;
    protected BpelFaultException lastException = null;
    protected BpelExecution compensateExecution;

    protected ScopeRuntime() {
    }

    public ScopeRuntime(Scope scopeDefinition, BpelExecution execution) {
        this.activityInstanceUUID = execution.getActivityInstanceUUID();
        this.scopeNodeUUID = scopeDefinition.getScopeNode().getName();
        this.createVariables(scopeDefinition, execution);
        this.createPartnerLinks(scopeDefinition, execution);
        this.createCorrelationSets(scopeDefinition, execution);
        this.state = ScopeState.INITIALIZED;
    }

    void addEndedChild(ScopeRuntime scopeRuntime) {
        scopeRuntime.setParent(this);
        scopeRuntime.setEndedTime(System.currentTimeMillis());
        this.getEndedChildren().add(scopeRuntime);
    }

    void setEndedTime(long endedTime) {
        this.endedTime = endedTime;
    }

    public void setParent(ScopeRuntime parent) {
        this.parent = parent;
    }

    public List<ScopeRuntime> getEndedChildren() {
        return this.endedChildren;
    }

    private void createVariables(Scope scopeDefinition, BpelExecution execution) {
        this.variables = new HashMap<String, VariableRuntime>();
        Map<String, Variable> scopeVariables = scopeDefinition.getVariables();
        if (scopeVariables != null) {
            for (Variable variable : scopeVariables.values()) {
                this.variables.put(variable.getName(), new VariableRuntime(variable, execution, this));
            }
        }
    }

    public Collection<String> getVariableNames() {
        if (this.variables == null) {
            return Collections.emptySet();
        }
        return this.variables.keySet();
    }

    public VariableRuntime createVariable(BpelExecution execution, Variable variable) {
        VariableRuntime variableRuntime = new VariableRuntime(variable, execution, this);
        this.variables.put(variable.getName(), variableRuntime);
        return variableRuntime;
    }

    public void removeVariable(BpelExecution execution, Variable variable) {
        this.variables.remove(variable.getName());
    }

    private void createPartnerLinks(Scope scopeDefinition, BpelExecution execution) {
        this.partnerLinks = new HashMap<String, PartnerLinkRuntime>();
        Map<String, PartnerLink> scopePartnerLinks = scopeDefinition.getPartnerLinks();
        if (scopePartnerLinks != null) {
            for (PartnerLink partnerLink : scopePartnerLinks.values()) {
                PartnerLinkRuntime partnerLinkRuntime = new PartnerLinkRuntime(partnerLink, execution, this);
                this.partnerLinks.put(partnerLink.getName(), partnerLinkRuntime);
            }
        }
    }

    private void createCorrelationSets(Scope scopeDefinition, BpelExecution execution) {
        this.correlationSets = new HashMap<String, CorrelationSetRuntime>();
        Map<String, CorrelationSet> correlationSetsMap = scopeDefinition.getCorrelationSets();
        if (correlationSetsMap != null) {
            for (CorrelationSet correlationSet : correlationSetsMap.values()) {
                CorrelationSetRuntime correlationSetRuntime = new CorrelationSetRuntime(correlationSet, this);
                this.correlationSets.put(correlationSet.getName(), correlationSetRuntime);
            }
        }
    }

    public PartnerLinkRuntime getPartnerLink(String partnerLinkName) {
        return this.getPartnerLinks().get(partnerLinkName);
    }

    public CorrelationSetRuntime getCorrelationSet(String csName) {
        return this.getCorrelationSets().get(csName);
    }

    public Map<String, CorrelationSetRuntime> getCorrelationSets() {
        return this.correlationSets;
    }

    public Map<String, PartnerLinkRuntime> getPartnerLinks() {
        return this.partnerLinks;
    }

    public VariableRuntime getVariable(String variableName) {
        return this.getVariables().get(variableName);
    }

    public Map<String, VariableRuntime> getVariables() {
        return this.variables;
    }

    public boolean containsVariable(String variableName) {
        return this.getVariables().containsKey(variableName);
    }

    public int hashCode() {
        return this.activityInstanceUUID.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScopeRuntime)) {
            return false;
        }
        ScopeRuntime other = (ScopeRuntime)obj;
        return other.getActivityInstanceUUID().equals(this.getActivityInstanceUUID());
    }

    public List<ScopeRuntime> getEndedChildrenOrderedByEndTime() {
        ArrayList<ScopeRuntime> result = new ArrayList<ScopeRuntime>(this.endedChildren);
        Collections.sort(result, new ScopeRuntimeEndTimeComparator());
        return result;
    }

    public ScopeState getState() {
        return this.state;
    }

    public boolean isCompenseable() {
        return ScopeState.COMPLETED_SUCCESSFUL.equals((Object)this.state);
    }

    public void setState(ScopeState newState, BpelExecution execution) {
        this.state = newState;
        AbstractActivity activity = execution.getNode().getBehaviour();
        EnvTool.getRecorder().recordScopeStateChanged(new ScopeStateUpdateData(this.activityInstanceUUID, activity.createRuntimeData(execution), newState));
    }

    public BpelFaultException getLastException() {
        return this.lastException;
    }

    public void setLastException(BpelFaultException lastException) {
        this.lastException = lastException;
    }

    public ActivityInstanceUUID getActivityInstanceUUID() {
        return this.activityInstanceUUID;
    }

    public BpelExecution getCompensateExecution() {
        return this.compensateExecution;
    }

    public void setCompensateExecution(BpelExecution compensateExecution) {
        this.compensateExecution = compensateExecution;
    }

    public String getScopeNodeUUID() {
        return this.scopeNodeUUID;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ScopeRuntimeEndTimeComparator
    implements Comparator<ScopeRuntime>,
    Serializable {
        private ScopeRuntimeEndTimeComparator() {
        }

        @Override
        public int compare(ScopeRuntime o1, ScopeRuntime o2) {
            return Long.valueOf(o1.endedTime).compareTo(o2.endedTime);
        }
    }
}

