/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.data.runtime.ActivityInstanceData;
import org.ow2.orchestra.facade.data.runtime.VariableUpdateData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;

public class VariableRuntime {
    protected long dbid;
    protected int dbversion;
    protected String name;
    protected Document xmlValue;
    protected ScopeRuntime scopeRuntime;
    protected boolean isMessage;

    protected VariableRuntime() {
    }

    public VariableRuntime(Variable variableDefinition, BpelExecution execution, ScopeRuntime scopeRuntime) {
        this.scopeRuntime = scopeRuntime;
        this.name = variableDefinition.getName();
        this.xmlValue = XmlUtil.copyDocument(variableDefinition.getDefaultValue());
        this.isMessage = variableDefinition.getMessageType() != null;
    }

    public void initializeVariable(BpelExecution execution, Variable variableDefinition) {
        Copy initCopy = variableDefinition.getVirtualCopy();
        if (initCopy != null) {
            initCopy.execute(execution);
        }
        AbstractActivity activity = execution.getNode().getBehaviour();
        this.updated(activity.createRuntimeData(execution));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        if (this.isMessage()) {
            return new MessageVariable(this.xmlValue);
        }
        if (this.xmlValue == null) {
            return null;
        }
        return this.xmlValue.getDocumentElement();
    }

    public void setValue(MessageVariable message) {
        if (!this.isMessage()) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.mismatchedAssignmentFailure, "trying to set a messageValue and the variableDefinition is not a messageType : " + this.toString(), null);
        }
        this.xmlValue = message.getPartsAsDocument();
    }

    public void setValue(Object value, boolean keepSrcElementName) {
        if (this.isMessage()) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.mismatchedAssignmentFailure, "trying to set a xmlValue and the variableDefinition is a messageType : " + this.toString(), null);
        }
        BpelXmlUtil.setObjectValue(this.xmlValue.getDocumentElement(), value, keepSrcElementName);
    }

    public void updated(ActivityInstanceData activityInstanceData) {
        if ("ORCHESTRA_4_INBOUND_WSDL_MESSAGE".equals(this.name) || "ORCHESTRA_4_OUTBOUND_WSDL_MESSAGE".equals(this.name)) {
            return;
        }
        if (!this.isMessage()) {
            EnvTool.getRecorder().recordVariableUpdated(new VariableUpdateData(this.scopeRuntime.getActivityInstanceUUID(), activityInstanceData, this.name, this.xmlValue.getDocumentElement()));
        } else {
            EnvTool.getRecorder().recordVariableUpdated(new VariableUpdateData(this.scopeRuntime.getActivityInstanceUUID(), activityInstanceData, this.name, new MessageVariable(this.xmlValue)));
        }
    }

    public long getDbid() {
        return this.dbid;
    }

    public boolean isMessage() {
        return this.isMessage;
    }

    public ScopeRuntime getScopeRuntime() {
        return this.scopeRuntime;
    }
}

