/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.CorrelationSetRuntime;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.util.QNameComparator;
import org.ow2.orchestra.util.ReceivingElementUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitingExecution {
    protected long dbid;
    protected int dbversion;
    protected String inboundMessageElementName;
    protected BpelExecution bpelExecution;
    protected Set<CorrelationSetRuntime> correlationSetRuntimes;
    protected List<Integer> correlationKeys = new ArrayList<Integer>();

    protected WaitingExecution() {
    }

    public WaitingExecution(BpelExecution bpelExecution, InboundMessageElement inboundMessageElement) {
        this.bpelExecution = bpelExecution;
        this.correlationSetRuntimes = new HashSet<CorrelationSetRuntime>();
        for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
            TreeMap<QName, Document> csProperties = new TreeMap<QName, Document>(QNameComparator.INSTANCE);
            for (Correlation correlation : receivingElement.getCorrelations()) {
                String correlationSetName = correlation.getCorrelationSet().getName();
                CorrelationSetRuntime csRuntime = bpelExecution.getCorrelationSetByName(correlationSetName);
                if (csRuntime == null) {
                    throw new OrchestraRuntimeException("CorrelationSetRuntime " + correlationSetName + " not found");
                }
                if (correlation.getInitiate().equals((Object)Correlation.Initiate.no) || correlation.getInitiate().equals((Object)Correlation.Initiate.join)) {
                    csProperties.putAll(csRuntime.getPropertyValues());
                }
                this.correlationSetRuntimes.add(csRuntime);
            }
            this.correlationKeys.add(ReceivingElementUtil.getCorrelationPropertiesKey(csProperties));
        }
        this.inboundMessageElementName = inboundMessageElement.getUUID().toString();
    }

    public BpelExecution getBpelExecution() {
        return this.bpelExecution;
    }

    protected void setBpelExecution(BpelExecution bpelExecution) {
        this.bpelExecution = bpelExecution;
    }

    public Set<CorrelationSetRuntime> getCorrelationSetRuntimes() {
        return this.correlationSetRuntimes;
    }

    public String getInboundMessageElementName() {
        return this.inboundMessageElementName;
    }

    public String toString() {
        return "WaitingExecution[" + this.dbid + "]";
    }

    public static interface WaitingExecutionIterator {
        public WaitingExecution next();
    }
}

