/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime.op;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.op.AtomicOperation;
import org.ow2.orchestra.util.Misc;

public class ExecuteNode
implements AtomicOperation {
    private static final Logger LOG = Logger.getLogger(ExecuteNode.class.getName());

    public void perform(BpelExecution execution) {
        Node node = execution.getNode();
        Misc.fastDynamicLog(LOG, Level.FINEST, "%s executing %s", execution, node);
        AbstractActivity activity = node.getBehaviour();
        try {
            execution.setWaitForSignal(false);
            activity.execute(execution);
        }
        catch (Exception e) {
            execution.handleException(node, e, execution.toString() + " couldn't execute " + activity + " for node " + node);
        }
        if (!execution.isWaitForSignal()) {
            execution.proceed();
        }
    }

    public String toString() {
        return "execute(node)";
    }
}

