/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime.op;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.op.AtomicOperation;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signal
implements AtomicOperation {
    private static final Logger LOG = Logger.getLogger(Signal.class.getName());
    private final String signalName;
    private final Map<String, Object> parameters;
    private final Node node;

    public Signal(String signalName, Map<String, Object> parameters, Node node) {
        this.signalName = signalName;
        this.parameters = parameters;
        this.node = node;
    }

    @Override
    public void perform(BpelExecution execution) {
        Misc.fastDynamicLog(LOG, Level.FINEST, "%s signals %s, signal=%s", execution.toString(), this.node, this.signalName);
        AbstractActivity activity = this.node.getBehaviour();
        try {
            execution.setWaitForSignal(false);
            activity.signal(execution, this.signalName, this.parameters);
        }
        catch (Exception e) {
            execution.handleException(this.node, e, execution.toString() + " couldn't signal node " + this.node);
        }
        if (!execution.isWaitForSignal()) {
            execution.proceed();
        }
    }

    public String toString() {
        return "signal(node)";
    }
}

