/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.wsdl.Definition;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.persistence.Transaction;
import org.ow2.orchestra.persistence.db.MessageSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ProcessInstanceMessageCarrier;
import org.ow2.orchestra.services.ReceivingService;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.services.impl.ProcessEndpoint;
import org.ow2.orchestra.services.impl.PublisherImpl;
import org.ow2.orchestra.services.itf.Invoker;
import org.ow2.orchestra.services.job.ExecuteInvokeJob;
import org.ow2.orchestra.services.job.Job;
import org.ow2.orchestra.services.job.SignalInvokeJob;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.services.jobexecutor.JobExceptionHandler;
import org.ow2.orchestra.util.AddressingUtil;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.PrefixThreadFactory;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeExecutor {
    private static final Logger LOG = Logger.getLogger(InvokeExecutor.class.getName());
    private final ThreadPoolExecutor executorService;

    public InvokeExecutor(int maxThreads) {
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(maxThreads, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PrefixThreadFactory("InvokeExecutor"));
        try {
            Method m = ThreadPoolExecutor.class.getDeclaredMethod("allowCoreThreadTimeOut", Boolean.TYPE);
            m.invoke((Object)tpe, Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executorService = tpe;
    }

    public void executeInvoke(Environment environment, BpelExecution execution, OperationKey operationKey, Element partnerEndPointReference, MessageVariable requestMessage, Set<Definition> wsdlDefinitions) {
        ProcessEndpoint processEndpoint;
        CommandService commandService = environment.get(CommandService.class);
        Properties orchestraProperties = (Properties)Environment.getFromCurrent("orchestra-properties");
        long executionId = execution.getDbid();
        AddressingUtil.AddressingInfo addressingInfo = AddressingUtil.getAddressingInfo(partnerEndPointReference, orchestraProperties);
        PublisherImpl publisher = environment.get(PublisherImpl.class);
        if (publisher != null && (processEndpoint = publisher.getProcessEndpoint(addressingInfo.getAddress())) != null) {
            OperationKey processOpKey = new OperationKey(processEndpoint.getProcessQName(), operationKey.getPortTypeQName(), operationKey.getOperationName());
            ProcessInstanceMessageCarrier interProcessMessageCarrier = null;
            boolean isOneWay = processEndpoint.isOneWay(operationKey.getOperationName());
            if (!isOneWay) {
                interProcessMessageCarrier = new ProcessInstanceMessageCarrier(executionId);
            }
            ReceivingService.handle(requestMessage, processOpKey, interProcessMessageCarrier, processEndpoint.isLock(operationKey.getOperationName()), commandService, execution.getProcessInstance().getParentInstanceStartTime());
            if (isOneWay) {
                FinishInvokeCommand fic = new FinishInvokeCommand(executionId, (MessageVariable)null);
                fic.setExecution(execution);
                fic.execute(environment);
            }
            return;
        }
        Invoker invoker = EnvTool.get(Invoker.class, "serviceInvoker");
        Transaction transaction = environment.get(Transaction.class);
        final InvokeCall invokeCall = new InvokeCall(executionId, invoker, operationKey, addressingInfo, requestMessage, wsdlDefinitions, commandService, orchestraProperties);
        if (transaction == null) {
            this.executorService.execute(invokeCall);
        } else {
            transaction.registerSynchronization(new Synchronization(){

                public void afterCompletion(int status) {
                    if (status == 3) {
                        InvokeExecutor.this.executorService.execute(invokeCall);
                    }
                }

                public void beforeCompletion() {
                }
            });
        }
    }

    public ThreadPoolExecutor getExecutorService() {
        return this.executorService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvokeCall
    implements Runnable {
        private final Invoker invoker;
        private final OperationKey operationKey;
        private final AddressingUtil.AddressingInfo addressingInfo;
        private final MessageVariable requestMessage;
        private final long executionId;
        private final CommandService commandService;
        private final Set<Definition> wsdlDefinitions;
        private final Properties orchestraProperties;

        public InvokeCall(long executionId, Invoker invoker, OperationKey operationKey, AddressingUtil.AddressingInfo addressingInfo, MessageVariable requestMessage, Set<Definition> wsdlDefinitions, CommandService commandService, Properties orchestraProperties) {
            this.executionId = executionId;
            this.invoker = invoker;
            this.operationKey = operationKey;
            this.addressingInfo = addressingInfo;
            this.requestMessage = requestMessage;
            this.wsdlDefinitions = wsdlDefinitions;
            this.commandService = commandService;
            this.orchestraProperties = orchestraProperties;
        }

        @Override
        public void run() {
            FinishInvokeCommand fic;
            try {
                MessageVariable responseMsg = this.invoker.invoke(this.operationKey, this.addressingInfo, this.requestMessage, this.wsdlDefinitions, this.orchestraProperties);
                fic = new FinishInvokeCommand(this.executionId, responseMsg);
            }
            catch (Exception e) {
                fic = new FinishInvokeCommand(this.executionId, e);
            }
            this.commandService.execute(fic);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FinishInvokeCommand
    implements Command<Void> {
        private static final long serialVersionUID = 3441149649002017059L;
        private BpelExecution execution;
        private final long executionId;
        private final MessageVariable responseMessage;
        private final Exception exception;

        public FinishInvokeCommand(long executionId, MessageVariable responseMessage) {
            this.executionId = executionId;
            this.responseMessage = responseMessage;
            this.exception = null;
        }

        public FinishInvokeCommand(long executionId, Exception exception) {
            this.executionId = executionId;
            this.responseMessage = null;
            this.exception = exception;
        }

        public void setExecution(BpelExecution execution) {
            this.execution = execution;
        }

        @Override
        public Void execute(Environment environment) {
            BpelExecution bpelExecution = this.execution == null ? EnvTool.getRepository().getUpdatedExecution(this.executionId) : this.execution;
            if (bpelExecution == null) {
                Misc.fastDynamicLog(LOG, Level.INFO, "Invoke response not delivered to execution %s: execution has been removed.", this.executionId);
                return null;
            }
            if (bpelExecution.isFinished()) {
                Misc.fastDynamicLog(LOG, Level.INFO, "Invoke response not delivered to execution %s: execution is finished.", bpelExecution);
                return null;
            }
            ExecuteInvokeJob invokeJob = null;
            for (Job job : bpelExecution.getJobs()) {
                if (!(job instanceof ExecuteInvokeJob)) continue;
                invokeJob = (ExecuteInvokeJob)job;
                break;
            }
            if (invokeJob == null) {
                Misc.unreachableStatement("unable to find invoke job");
                return null;
            }
            if (this.exception == null || this.exception instanceof BpelFaultException) {
                Misc.fastDynamicLog(LOG, Level.INFO, "Deliver invoke response to execution %s", bpelExecution);
                boolean bl = invokeJob.isSuspended();
                environment.get(JobDbSession.class).delete(invokeJob);
                SignalInvokeJob signalInvokeJob = new SignalInvokeJob(this.responseMessage, this.exception);
                signalInvokeJob.setExecution(bpelExecution);
                signalInvokeJob.setSuspended(bl);
                environment.get(MessageSession.class).send(signalInvokeJob);
            } else {
                JobExceptionHandler jobExceptionHandler = new JobExceptionHandler(invokeJob, (Throwable)this.exception);
                jobExceptionHandler.execute(environment);
            }
            return null;
        }
    }
}

