/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.commands;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.StaleStateException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.LockAcquisitionException;
import org.ow2.orchestra.facade.exception.DeploymentException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.Interceptor;
import org.ow2.orchestra.services.jobexecutor.AcquireJobsCmd;
import org.ow2.orchestra.services.jobexecutor.ExecuteJobCmd;
import org.ow2.orchestra.util.ArchiveTool;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryInterceptor
extends Interceptor {
    private static final Logger LOG = Logger.getLogger(RetryInterceptor.class.getName());
    private static final Random RANDOM = new Random();
    private int retries = 3;
    private long delay = 50L;
    private long maxDelay = 5000L;
    private int delayFactor = 2;

    @Override
    public <T> T execute(Command<T> command) {
        int attempt = 1;
        long sleepTime = this.delay;
        long attemptFactor = this.delayFactor;
        while (attempt <= this.retries) {
            if (attempt > 1) {
                Misc.fastDynamicLog(LOG, Level.FINEST, "retrying...", new Object[0]);
            }
            try {
                return this.next.execute(command);
            }
            catch (RuntimeException e) {
                if (this.shouldRetry(command, e)) {
                    Misc.fastDynamicLog(LOG, Level.FINEST, "command failed: %s %s", e, Misc.getStackTraceFrom(e));
                    if (++attempt > this.retries) {
                        Misc.fastDynamicLog(LOG, Level.SEVERE, "gave up after %s attempts. Last exception was: %s %s", attempt, e, Misc.getStackTraceFrom(e));
                        throw e;
                    }
                    Misc.fastDynamicLog(LOG, Level.FINEST, "waiting %s millis", sleepTime);
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e1) {
                        Misc.fastDynamicLog(LOG, Level.FINEST, "retry sleeping got interrupted", new Object[0]);
                    }
                    if ((sleepTime = this.delay * (attemptFactor *= (long)(1 + RANDOM.nextInt(this.delayFactor - 1)))) <= this.maxDelay) continue;
                    sleepTime = this.maxDelay;
                    continue;
                }
                throw e;
            }
        }
        throw new OrchestraRuntimeException("gave up after " + attempt + " attempts");
    }

    protected boolean shouldRetry(Command<?> command, RuntimeException e) {
        if (command instanceof ExecuteJobCmd) {
            return false;
        }
        if (command instanceof AcquireJobsCmd) {
            return false;
        }
        if (e instanceof DeploymentException) {
            return false;
        }
        if (e instanceof ArchiveTool.AtomicArchiveException) {
            return true;
        }
        if (e instanceof OrchestraWrapperException) {
            return false;
        }
        if (e instanceof OrchestraRuntimeException) {
            return true;
        }
        if (e instanceof IllegalStateException) {
            return true;
        }
        if (e instanceof HibernateException) {
            return true;
        }
        return e instanceof StaleStateException || e instanceof LockAcquisitionException || e instanceof GenericJDBCException;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public int getDelayFactor() {
        return this.delayFactor;
    }

    public void setDelayFactor(int delayFactor) {
        this.delayFactor = delayFactor;
    }

    public long getMaxDelay() {
        return this.maxDelay;
    }

    public void setMaxDelay(long maxDelay) {
        this.maxDelay = maxDelay;
    }

    public static Random getRandom() {
        return RANDOM;
    }
}

