/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.deployment.ActiveProcessHolder;
import org.ow2.orchestra.deployment.ProcessDeploymentCounter;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.db.RuntimeDbSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.BpelInstance;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.WaitingExecution;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.services.impl.PublisherImpl;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.services.job.Job;
import org.ow2.orchestra.services.job.JobImpl;
import org.ow2.orchestra.util.EnvTool;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbRepository
implements Repository {
    @Override
    public long getNextProcessCount() {
        ProcessDeploymentCounter processDeploymentCounter = this.getBpelPersistenceService().getProcessDeploymentCounter();
        if (processDeploymentCounter == null) {
            processDeploymentCounter = new ProcessDeploymentCounter();
            this.getBpelPersistenceService().save(processDeploymentCounter);
        }
        return processDeploymentCounter.getAndIncrementProcessCounter();
    }

    @Override
    public BpelProcess getActiveProcess(QName processQName) {
        ProcessDefinitionUUID activeProcessUUID;
        ActiveProcessHolder activeProcessHolder = this.getBpelPersistenceService().findActiveBpelProcess(processQName);
        if (activeProcessHolder != null && (activeProcessUUID = activeProcessHolder.getProcessUUID()) != null) {
            return this.getProcess(activeProcessUUID);
        }
        return null;
    }

    @Override
    public BpelProcess getProcess(ProcessDefinitionUUID processUUID) {
        BpelProcess process;
        PublisherImpl publisherImpl = Environment.getFromCurrent(PublisherImpl.class, false);
        if (publisherImpl != null && (process = publisherImpl.getBpelProcess(processUUID)) != null) {
            return process;
        }
        return this.getBpelPersistenceService().getBpelProcess(processUUID);
    }

    @Override
    public List<BpelProcess> getProcesses(QName processQName) {
        List<ProcessDefinitionUUID> uuids = this.getBpelPersistenceService().findBpelProcesses(processQName, false);
        return this.getBpelProcesses(uuids);
    }

    @Override
    public List<BpelProcess> getProcesses() {
        return this.getBpelProcesses(this.getBpelPersistenceService().getBpelProcessesUUID());
    }

    @Override
    public BpelProcess removeProcess(QName processQName) {
        BpelProcess process = this.getActiveProcess(processQName);
        if (process != null) {
            this.getBpelPersistenceService().delete(process);
            PublisherImpl publisherImpl = Environment.getFromCurrent(PublisherImpl.class, false);
            if (publisherImpl != null) {
                publisherImpl.removeBpelProcess(process);
            }
        }
        return process;
    }

    @Override
    public BpelProcess removeProcess(ProcessDefinitionUUID pduuid) {
        BpelProcess process = this.getBpelPersistenceService().getBpelProcess(pduuid);
        if (process != null) {
            this.getBpelPersistenceService().delete(process);
            List<BpelProcess> otherVersions = this.getProcesses(process.getQName());
            otherVersions.remove(process);
            if (otherVersions.isEmpty()) {
                ActiveProcessHolder activeProcessHolder = this.getBpelPersistenceService().findActiveBpelProcess(process.getQName());
                this.getBpelPersistenceService().delete(activeProcessHolder);
            }
        }
        return process;
    }

    @Override
    public void storeProcess(BpelProcess process) {
        this.getBpelPersistenceService().save(process);
        ActiveProcessHolder activeProcessHolder = this.getBpelPersistenceService().findActiveBpelProcess(process.getQName());
        if (activeProcessHolder == null) {
            activeProcessHolder = new ActiveProcessHolder(process.getQName());
            this.getBpelPersistenceService().save(activeProcessHolder);
        }
        activeProcessHolder.setProcessUUID(process.getUUID());
    }

    @Override
    public List<BpelProcess> lockProcesses(QName processQName) {
        List<ProcessDefinitionUUID> uuids = this.getBpelPersistenceService().findBpelProcesses(processQName, true);
        return this.getBpelProcesses(uuids);
    }

    private List<BpelProcess> getBpelProcesses(List<ProcessDefinitionUUID> uuids) {
        if (uuids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BpelProcess> result = new ArrayList<BpelProcess>();
        for (ProcessDefinitionUUID processUUID : uuids) {
            result.add(this.getProcess(processUUID));
        }
        return result;
    }

    @Override
    public BpelInstance getInstance(ProcessInstanceUUID processInstanceUUID) {
        return this.getBpelPersistenceService().getBpelInstance(processInstanceUUID);
    }

    @Override
    public List<BpelInstance> getInstances() {
        return this.getBpelPersistenceService().getBpelInstances();
    }

    @Override
    public List<BpelInstance> getInstances(QName processQName) {
        return this.getBpelPersistenceService().getBpelInstances(processQName);
    }

    @Override
    public List<BpelInstance> getInstances(ProcessDefinitionUUID pduuid) {
        return this.getBpelPersistenceService().getBpelInstances(pduuid);
    }

    @Override
    public void removeInstance(BpelInstance instance) {
        this.removeInstance(instance, false);
    }

    @Override
    public void storeExecution(BpelExecution child) {
        this.getBpelPersistenceService().save(child);
    }

    @Override
    public void removeExecution(BpelExecution child) {
        this.getBpelPersistenceService().delete(child);
    }

    @Override
    public void storeScopeRuntime(ScopeRuntime scopeRuntime) {
        this.getBpelPersistenceService().save(scopeRuntime);
    }

    @Override
    public void removeScopeRuntime(ScopeRuntime scopeRuntime) {
        this.getBpelPersistenceService().delete(scopeRuntime);
    }

    @Override
    public void storeWaitingExecution(WaitingExecution waitingExecution) {
        this.getBpelPersistenceService().save(waitingExecution);
    }

    @Override
    public void removeWaitingExecution(WaitingExecution waitingExecution) {
        this.getBpelPersistenceService().delete(waitingExecution);
    }

    @Override
    public void removeInstance(BpelInstance instance, boolean force) {
        if (force && instance != null && (instance.getProcessInstanceState().equals((Object)ActivityState.RUNNING) || instance.getProcessInstanceState().equals((Object)ActivityState.SUSPENDED))) {
            instance.exit();
        }
        if (instance != null) {
            this.getBpelPersistenceService().delete(instance);
        }
    }

    @Override
    public void storeInstance(BpelInstance instance) {
        this.getBpelPersistenceService().save(instance.getProcessInstance());
    }

    @Override
    public BpelExecution getUpdatedExecution(long executionId) {
        return this.getBpelPersistenceService().get(BpelExecution.class, executionId);
    }

    @Override
    public List<Job> findJobsWithException() {
        return this.getBpelPersistenceService().findJobsWithException();
    }

    @Override
    public JobImpl<?> getJob(long jobId) {
        return this.getBpelPersistenceService().get(JobImpl.class, jobId);
    }

    @Override
    public WaitingExecution.WaitingExecutionIterator getWaitingExecutions(ReceivingElement receivingElement, Map<QName, Document> csProperties) {
        return this.getBpelPersistenceService().getWaitingExecutions(receivingElement, csProperties);
    }

    @Override
    public WaitingExecution getFirstWaitingExecution(InboundMessageElement inboundMessageElement) {
        return this.getBpelPersistenceService().getFirstWaitingExecution(inboundMessageElement);
    }

    @Override
    public void storePendingMessage(PendingMessage pendingMessage) {
        this.getBpelPersistenceService().save(pendingMessage);
    }

    @Override
    public void removePendingMessage(PendingMessage pendingMessage) {
        this.getBpelPersistenceService().delete(pendingMessage);
    }

    @Override
    public Collection<PendingMessage> getPendingMessages(OperationKey operationKey) {
        return this.getBpelPersistenceService().getPendingMessages(operationKey);
    }

    private RuntimeDbSession getBpelPersistenceService() {
        return Environment.getCurrent().get(RuntimeDbSession.class);
    }

    @Override
    public void activateProcess(BpelProcess bpelProcess) {
        this.changeProcessState(bpelProcess, false);
    }

    @Override
    public void retireProcess(BpelProcess bpelProcess) {
        this.changeProcessState(bpelProcess, true);
    }

    private void changeProcessState(BpelProcess bpelProcess, boolean retired) {
        ActiveProcessHolder activeProcessHolder = this.getBpelPersistenceService().findActiveBpelProcess(bpelProcess.getQName());
        if (bpelProcess.getUUID().equals(activeProcessHolder.getProcessUUID())) {
            if (retired) {
                activeProcessHolder.setProcessUUID(null);
                EnvTool.getRecorder().recordProcessStateChanged(bpelProcess.getProcessDefinitionData());
            }
        } else if (!retired) {
            activeProcessHolder.setProcessUUID(bpelProcess.getUUID());
            EnvTool.getRecorder().recordProcessStateChanged(bpelProcess.getProcessDefinitionData());
        }
    }

    @Override
    public void refreshActiveProcess(ProcessDefinitionUUID pduuid) {
        BpelProcess process = this.getProcess(pduuid);
        if (process != null) {
            this.getBpelPersistenceService().clearActiveProcessCache(process.getQName());
        }
    }
}

