/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.DeploymentException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.services.impl.ProcessEndpoint;
import org.ow2.orchestra.services.itf.Publisher;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.wsdl.WsdlComparator;
import org.ow2.orchestra.wsdl.WsdlsInfos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublisherImpl
implements Publisher {
    private static final Logger LOG = Logger.getLogger(PublisherImpl.class.getName());
    private final Map<ProcessDefinitionUUID, BpelProcess> bpelProcesses = new HashMap<ProcessDefinitionUUID, BpelProcess>();
    private final Map<String, ProcessEndpoint> processEndpoints = new HashMap<String, ProcessEndpoint>();

    @Override
    public void publishServices(BpelProcess bpelProcess, Environment environment) {
        Misc.fastDynamicLog(LOG, Level.INFO, "Publishing services for Bpel process %s (%s).", bpelProcess.getUUID(), bpelProcess.getQName());
        this.addBpelProcess(bpelProcess);
    }

    @Override
    public void unpublishServices(BpelProcess bpelProcess, Environment environment) {
        Misc.fastDynamicLog(LOG, Level.INFO, "Unpublishing services for Bpel process %s (%s).", bpelProcess.getUUID(), bpelProcess.getQName());
        this.removeBpelProcess(bpelProcess);
    }

    @Override
    public Set<OperationKey> getServiceOperationKeys(BpelProcess bpelProcess, Environment environment) {
        return this.getServiceOperationKeys(bpelProcess, bpelProcess.getInitial(), environment);
    }

    protected Set<OperationKey> getServiceOperationKeys(BpelProcess bpelProcess, Node node, Environment environment) {
        List<Node> children;
        HashSet<OperationKey> operationKeys = new HashSet<OperationKey>();
        AbstractActivity behaviour = node.getBehaviour();
        if (behaviour.isInboundMessageElement()) {
            InboundMessageElement inboundMessageElement = (InboundMessageElement)((Object)behaviour);
            for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
                OperationKey operationKey = receivingElement.getOperationKey();
                operationKeys.add(operationKey);
            }
        }
        if ((children = node.getNodes()) != null) {
            for (Node child : children) {
                operationKeys.addAll(this.getServiceOperationKeys(bpelProcess, child, environment));
            }
        }
        return operationKeys;
    }

    public Set<Definition> getWsdlDefinitions(ProcessDefinitionUUID processDefinitionUUID) {
        if (this.bpelProcesses.containsKey(processDefinitionUUID)) {
            return this.bpelProcesses.get(processDefinitionUUID).getWsdlInfos().getWsdlDefinitions();
        }
        return null;
    }

    public BpelProcess getBpelProcess(ProcessDefinitionUUID processDefinitionUUID) {
        return this.bpelProcesses.get(processDefinitionUUID);
    }

    public void addBpelProcess(BpelProcess bpelProcess) {
        this.bpelProcesses.put(bpelProcess.getUUID(), bpelProcess);
    }

    public void removeBpelProcess(BpelProcess bpelProcess) {
        this.bpelProcesses.remove(bpelProcess.getUUID());
    }

    public boolean addProcessEndpoint(String endpoint, QName processQName, Port port, ProcessDefinitionUUID processDefinitionUUID, Map<String, Boolean> locks, Map<String, Boolean> isOneWay) {
        ProcessEndpoint processEndpoint;
        boolean isNewEndpoint;
        boolean bl = isNewEndpoint = !this.processEndpoints.containsKey(endpoint);
        if (isNewEndpoint) {
            processEndpoint = new ProcessEndpoint(processQName, port);
            this.processEndpoints.put(endpoint, processEndpoint);
        } else {
            processEndpoint = this.processEndpoints.get(endpoint);
            WsdlComparator.checkSamePort(processEndpoint.getPort(), port);
            if (!processEndpoint.getProcessQName().equals(processQName)) {
                throw new DeploymentException("endpoint " + endpoint + " is already used by process " + processEndpoint.getProcessQName());
            }
        }
        processEndpoint.addProcessVersion(processDefinitionUUID, isOneWay, locks);
        return isNewEndpoint;
    }

    public boolean removeProcessEndpoint(String endpoint, ProcessDefinitionUUID processDefinitionUUID) {
        ProcessEndpoint processEndpoint = this.processEndpoints.get(endpoint);
        if (processEndpoint != null) {
            processEndpoint.removeProcessVersion(processDefinitionUUID);
            if (processEndpoint.isUndeployed()) {
                this.processEndpoints.remove(endpoint);
                return true;
            }
        }
        return false;
    }

    public ProcessEndpoint getProcessEndpoint(String endpoint) {
        return this.processEndpoints.get(endpoint);
    }

    protected List<Service> getServices(BpelProcess bpelProcess) {
        Set<OperationKey> opKeys = this.getServiceOperationKeys(bpelProcess, Environment.getCurrent());
        WsdlsInfos wsdlInfos = bpelProcess.getWsdlInfos();
        ArrayList<Service> services = null;
        ArrayList<QName> missingServices = new ArrayList<QName>();
        for (OperationKey operationKey : opKeys) {
            QName portTypeQName = operationKey.getPortTypeQName();
            List<Service> portTypeServices = wsdlInfos.getServicesOfPortType(portTypeQName);
            if (portTypeServices != null) {
                if (services == null) {
                    services = new ArrayList<Service>();
                }
                for (Service service : portTypeServices) {
                    if (services.contains(service)) continue;
                    services.add(service);
                }
                continue;
            }
            missingServices.add(portTypeQName);
        }
        if (!missingServices.isEmpty()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Some wsdl services not found for receiving activities. Please specify service for the following PortTypes: ");
            boolean first = true;
            for (QName ptQName : missingServices) {
                buf.append(first ? "" : ", ").append(ptQName.toString());
                first = false;
            }
            buf.append(".");
            throw new OrchestraRuntimeException(buf.toString());
        }
        return services;
    }
}

