/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.ow2.orchestra.exception.FaultWithMessageVariable;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.itf.Invoker;
import org.ow2.orchestra.util.AddressingUtil;
import org.ow2.orchestra.util.BpelSOAPUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.wsdl.WsdlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.ws.WSDeployer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPInvoker
implements Invoker {
    private static final Logger LOG = Logger.getLogger(SOAPInvoker.class.getName());

    @Override
    public MessageVariable invoke(OperationKey operationKey, AddressingUtil.AddressingInfo addressingInfo, MessageVariable requestMessage, Set<Definition> wsdlDefinitions, Properties orchestraProperties) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering(SOAPInvoker.class.getName(), "invoke", new Object[]{operationKey, addressingInfo.getPartnerEndPointReference(), requestMessage});
        }
        List<Service> services = WsdlUtil.getServicesOfPortType(operationKey.getPortTypeQName(), wsdlDefinitions);
        try {
            QName portTypeQName = operationKey.getPortTypeQName();
            String operationName = operationKey.getOperationName();
            Binding binding = null;
            addressingInfo.resolveServiceAndPort(services);
            Port matchingPort = addressingInfo.getPort();
            if (matchingPort != null && matchingPort.getBinding().getPortType().getQName().equals(portTypeQName) && WSDeployer.getSoapBindingFromBinding(matchingPort.getBinding()) != null) {
                binding = matchingPort.getBinding();
            }
            if (binding == null) {
                binding = this.getFirstSupportedBinding(services, portTypeQName);
            }
            if (binding == null) {
                throw new OrchestraRuntimeException("Can't find any supported binding!");
            }
            Operation operation = binding.getPortType().getOperation(operationName, null, null);
            String endpoint = addressingInfo.getAddress();
            String style = null;
            String use = null;
            String soapAction = null;
            SOAPBinding soapBinding = (SOAPBinding)WSDeployer.getFromList(binding.getExtensibilityElements(), SOAPBinding.class);
            style = soapBinding.getStyle();
            BindingOperation opBinding = binding.getBindingOperation(operationName, null, null);
            SOAPOperation soapOperation = (SOAPOperation)WSDeployer.getFromList(opBinding.getExtensibilityElements(), SOAPOperation.class);
            if (soapOperation.getStyle() != null) {
                style = soapOperation.getStyle();
            }
            soapAction = soapOperation.getSoapActionURI();
            SOAPBody soapBodyInput = (SOAPBody)WSDeployer.getFromList(opBinding.getBindingInput().getExtensibilityElements(), SOAPBody.class);
            use = soapBodyInput.getUse();
            if (soapAction == null) {
                throw new OrchestraRuntimeException("No soapAction specified for this operation : " + operationName);
            }
            Map inputParts = operation.getInput().getMessage().getParts();
            if (style.equals("document") && inputParts.size() > 1) {
                throw new OrchestraRuntimeException("Style is document but input message has many parts : not supported as WSI Basic profiles requires at most one part for document style");
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Create the call to the endPoint['" + endpoint + "']");
            }
            SOAPMessage request = null;
            if (style.equals("document")) {
                if (requestMessage.getParts().size() > 1) {
                    throw new OrchestraRuntimeException("Trying to perform a call with many parts using document style : WSI Basic profiles does not allow that : at most one part is expected (having the name of the operation");
                }
                request = BpelSOAPUtil.buildDocumentSOAPMessage(soapAction, requestMessage);
            } else {
                request = BpelSOAPUtil.buildRpcSOAPMessage(soapAction, requestMessage, operationName);
            }
            SOAPMessage response = SOAPUtil.call(request, endpoint);
            if (operation.getOutput() != null) {
                Map outputParts = operation.getOutput().getMessage().getParts();
                if (style.equals("document") && outputParts.size() > 1) {
                    throw new OrchestraRuntimeException("Style is document but output message has many parts : not supported as WSI Basic profiles requires at most one part for document style");
                }
                if (response == null) {
                    throw new OrchestraRuntimeException("This operation(" + binding.getQName() + ":" + operationName + ") requires a response but no response was received");
                }
                javax.xml.soap.SOAPBody soapBody = response.getSOAPBody();
                if (soapBody.hasFault()) {
                    Iterator detailEntries;
                    Detail detail;
                    Fault fault;
                    MessageVariable faultMessage = null;
                    SOAPFault soapFault = response.getSOAPBody().getFault();
                    Name faultName = soapFault.getFaultCodeAsName();
                    QName faultQName = new QName(faultName.getURI(), faultName.getLocalName());
                    if (portTypeQName.getNamespaceURI().equals(faultName.getURI()) && (fault = operation.getFault(faultName.getLocalName())) != null && (detail = soapFault.getDetail()) != null && (detailEntries = detail.getDetailEntries()).hasNext()) {
                        DetailEntry detailEntry = (DetailEntry)detailEntries.next();
                        faultMessage = BpelSOAPUtil.buildMessageFromDocumentSOAPBodyElement(fault.getMessage().getParts().values(), (Element)detailEntry);
                    }
                    throw new FaultWithMessageVariable(faultQName, faultMessage);
                }
                return this.getMessageSOAPFromResponse(response, outputParts, style, use);
            }
            return null;
        }
        catch (OrchestraRuntimeException oe) {
            throw oe;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught while invoke WS", e);
        }
    }

    private Binding getFirstSupportedBinding(List<Service> services, QName portTypeQName) {
        for (Service service : services) {
            for (Port port : service.getPorts().values()) {
                if (!port.getBinding().getPortType().getQName().equals(portTypeQName) || WSDeployer.getSoapBindingFromBinding(port.getBinding()) == null) continue;
                Binding binding = port.getBinding();
                Misc.fastDynamicLog(LOG, Level.FINE, "Using the first binding supported: %s", binding.getQName());
                return binding;
            }
        }
        return null;
    }

    private MessageVariable getMessageSOAPFromResponse(SOAPMessage response, Map<String, Part> outputParts, String style, String use) {
        try {
            Iterator bodyElementsIterator = response.getSOAPBody().getChildElements();
            if (!bodyElementsIterator.hasNext()) {
                throw new OrchestraRuntimeException("Exception caught while building a message from soapResponse (one and only one element was expected as a child of body but 0 were received) : " + response);
            }
            SOAPBodyElement element = (SOAPBodyElement)bodyElementsIterator.next();
            if (bodyElementsIterator.hasNext()) {
                throw new OrchestraRuntimeException("Exception caught while building a message from soapResponse (only one element was expected as a child of body but many were received) : " + response);
            }
            if (style.equals("document")) {
                return BpelSOAPUtil.buildMessageFromDocumentSOAPBodyElement(outputParts.values(), (Element)element);
            }
            return BpelSOAPUtil.buildMessageFromRpcSOAPBodyElement(outputParts.values(), (Element)element);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught while building a message from soapResponse : " + response, e);
        }
    }
}

