/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.job;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.persistence.Transaction;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.ExecElementToSignal;
import org.ow2.orchestra.services.Receiver;
import org.ow2.orchestra.services.SignalExecUtil;
import org.ow2.orchestra.services.job.MessageImpl;
import org.ow2.orchestra.services.job.TimerImpl;
import org.ow2.orchestra.services.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.services.jobexecutor.JobExecutor;
import org.ow2.orchestra.util.Clock;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckHasMessageJob
extends MessageImpl<Boolean> {
    private static final long serialVersionUID = 3671423433628407972L;
    private static final Logger LOG = Logger.getLogger(CheckHasMessageJob.class.getName());
    private static final int RETRIES = 3;
    private int repeat = 3;

    protected CheckHasMessageJob() {
    }

    public CheckHasMessageJob(BpelExecution execution) {
        this.setExecution(execution);
    }

    @Override
    public Boolean execute(Environment environment) {
        JobDbSession dbSession;
        BpelExecution bpelExecution = this.execution;
        ExecElementToSignal execElt = null;
        if (bpelExecution.hasWaitingExecution()) {
            execElt = Receiver.findMessageForExecution(bpelExecution);
        } else {
            Misc.fastDynamicLog(LOG, Level.FINEST, "execution is not waiting anymore: %s", bpelExecution);
        }
        if (this.repeat > 0 && execElt == null) {
            this.setDueDate(new Date(Clock.getCurrentTime().getTime() + (long)(5000 * (3 - this.repeat + 1))));
            Misc.fastDynamicLog(LOG, Level.FINEST, "rescheduled %s for %s", this, TimerImpl.formatDueDate(this.dueDate));
            this.setLockOwner(null);
            this.setLockExpirationTime(null);
            JobExecutor jobExecutor = environment.get(JobExecutor.class);
            if (jobExecutor != null) {
                Transaction transaction = environment.get(Transaction.class);
                if (transaction == null) {
                    throw new OrchestraRuntimeException("no transaction in environment");
                }
                JobAddedNotification jobNotificator = new JobAddedNotification(jobExecutor, this);
                transaction.registerSynchronization(jobNotificator);
            }
            --this.repeat;
            return Boolean.FALSE;
        }
        if (execElt != null) {
            SignalExecUtil.execute(environment, execElt.getBpelExecution(), execElt.getReceivingElement(), execElt.getPendingMessage());
        }
        if ((dbSession = environment.get(JobDbSession.class)) == null) {
            throw new OrchestraRuntimeException("no " + JobDbSession.class.getName() + " in environment");
        }
        dbSession.delete(this);
        return Boolean.TRUE;
    }
}

